/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.cloudpush;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.mobi.component.cloudpush.CloudPush;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.util.ClientDescriptor;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class CloudPushRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        String source = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (component.getClientId().equals(source)) {
            sessionMap.put(CloudPushRenderer.class.getName(), true);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean cloudPushEnabled;
        CloudPush cloudPush = (CloudPush)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = cloudPush.getClientId();
        ClientDescriptor clientDescriptor = ClientDescriptor.getInstance((HttpServletRequest)((HttpServletRequest)facesContext.getExternalContext().getRequest()));
        String email = cloudPush.getEmail();
        boolean desktopBrowser = clientDescriptor.isDesktopBrowser() || clientDescriptor.isSimulator();
        PushContext pushContext = PushContext.getInstance((ServletContext)EnvUtils.getSafeContext((FacesContext)facesContext));
        Cookie browserIDCookie = (Cookie)facesContext.getExternalContext().getRequestCookieMap().get("ice.push.browser");
        boolean bl = cloudPushEnabled = browserIDCookie == null ? false : pushContext.hasNotifyBackURI(browserIDCookie.getValue());
        if (!cloudPushEnabled && (!desktopBrowser || email != null && email.length() > 0)) {
            writer.startElement("button", cloudPush);
            writer.writeAttribute("id", clientId);
            writer.writeAttribute("class", "mobi-cloud-push");
            writer.writeAttribute("name", clientId + "_button");
            writer.writeAttribute("type", "submit");
            String script = "ice.s(this.form, this); " + (desktopBrowser ? "ice.push.parkInactivePushIds('mailto:" + email + "');" : "bridgeit.register();return false;");
            writer.writeAttribute("onclick", script);
            writer.startElement("span", cloudPush);
            writer.writeText(cloudPush.getButtonLabel());
            writer.endElement("span");
            writer.startElement("span", cloudPush);
            writer.startElement("script", cloudPush);
            writer.writeAttribute("type", "text/javascript");
            writer.writeText("new ice.mobi.button('" + clientId + "');");
            writer.endElement("script");
            writer.endElement("span");
            writer.endElement("button");
        }
    }
}

