/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.dataview;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.textentry.TextEntry;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.mobi.component.dataview.DataView;
import org.icefaces.mobi.component.dataview.DataViewColumns;
import org.icefaces.mobi.component.dataview.DataViewDetails;
import org.icefaces.mobi.model.dataview.DataViewColumnModel;
import org.icefaces.mobi.model.dataview.DataViewColumnsModel;
import org.icefaces.mobi.model.dataview.DataViewDataModel;
import org.icefaces.mobi.model.dataview.IndexedIterator;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class DataViewRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(DataViewRenderer.class.getName());
    private static final HashSet emptySet = new HashSet();
    private static final HashSet mobiTextEntryProperties = new HashSet(){
        {
            this.add("value");
            this.add("type");
            this.add("placeholder");
            this.add("readonly");
            this.add("maxlength");
            this.add("size");
            this.add("required");
            this.add("results");
            this.add("title");
            this.add("min");
            this.add("max");
            this.add("step");
            this.add("disabled");
            this.add("style");
            this.add("styleClass");
        }
    };
    private static final HashSet uiCommandProperties = new HashSet(){
        {
            this.add("value");
        }
    };
    private static final HashSet uiInputProperties = new HashSet(){
        {
            this.add("value");
        }
    };
    private static final HashSet uiOutputProperties = new HashSet(){
        {
            this.add("value");
        }
    };
    private static final List<Class> htmlValueHolders = new ArrayList<Class>(){
        {
            this.add(HtmlInputTextarea.class);
            this.add(HtmlOutputText.class);
            this.add(HtmlOutputLabel.class);
            this.add(HtmlCommandLink.class);
        }
    };
    private static final List<Class> attrValueHolders = new ArrayList<Class>(){
        {
            this.add(HtmlInputText.class);
            this.add(HtmlInputSecret.class);
            this.add(HtmlInputText.class);
            this.add(HtmlCommandButton.class);
            this.add(TextEntry.class);
        }
    };

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        Object sourceId = requestMap.get("ice.event.captured");
        if (sourceId != null && sourceId.toString().equals(uiComponent.getClientId(facesContext))) {
            this.decodeBehaviors(facesContext, (UIComponent)((DataView)uiComponent));
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        DataView dataView = (DataView)component;
        String dvId = dataView.getClientId();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)dvId, null);
        String styleClass = "mobi-dv ui-widget ui-widget-content";
        String userClass = dataView.getStyleClass();
        if (userClass != null) {
            styleClass = styleClass + " " + userClass;
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        String userStyle = dataView.getStyle();
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, null);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        DataView dataView = (DataView)component;
        ResponseWriter writer = context.getResponseWriter();
        this.encodeDetails(context, writer, dataView);
        this.encodeColumns(context, writer, dataView);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeScript(context, writer, (DataView)component);
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, ResponseWriter writer, DataView dataView) throws IOException {
        String dvId = dataView.getClientId();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(dvId + "_jswrp"), null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String activationMode = dataView.getClientBehaviors().isEmpty() ? "client" : "server";
        String cfg = "{";
        cfg = cfg + "active:'" + activationMode + "'";
        cfg = cfg + ",disabled:" + dataView.isDisabled();
        cfg = cfg + this.encodeClientBehaviors(context, (ClientBehaviorHolder)dataView, "action").toString();
        cfg = cfg + "}";
        String js = "ice.mobi.dataView.create(\"" + dvId + '\"' + ", " + cfg + ");";
        writer.writeText((Object)js, null);
        writer.endElement("script");
        writer.endElement("span");
    }

    private void encodeColumns(FacesContext context, ResponseWriter writer, DataView dataView) throws IOException {
        DataViewColumns columns = dataView.getColumns();
        String var = dataView.getVar();
        if (columns == null) {
            this.encodeEmptyBodyTable(writer);
        } else {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"mobi-dv-mst", null);
            DataViewColumnsModel columnModel = columns.getModel();
            DataViewDataModel dataModel = dataView.getDataModel();
            if (columnModel.hasHeaders()) {
                this.encodeHeaders(writer, columnModel, dataModel, true);
            }
            this.encodeRows(context, writer, dataView, var, columnModel, dataModel);
            if (columnModel.hasFooters()) {
                this.encodeFooters(writer, columnModel, dataModel, true);
            }
            writer.endElement("div");
        }
    }

    private void encodeEmptyBodyTable(ResponseWriter writer) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"mobi-dv-mst", null);
        writer.startElement("div", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"mobi-dv-body", null);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeHeaders(ResponseWriter writer, DataViewColumnsModel columnModel, DataViewDataModel dataModel, boolean writeTable) throws IOException {
        if (writeTable) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"mobi-dv-head", null);
        }
        writer.startElement("thead", null);
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-widget-header", null);
        IndexedIterator columnIter = columnModel.iterator();
        while (columnIter.hasNext()) {
            DataViewColumnModel column = (DataViewColumnModel)columnIter.next();
            int index = columnIter.getIndex();
            if (!column.isRendered()) continue;
            writer.startElement("th", null);
            String className = this.getColumnStyleClass(column, index);
            writer.writeAttribute("class", (Object)className, null);
            if (column.getHeaderText() != null) {
                writer.write(column.getHeaderText());
            }
            if (column.isSortable()) {
                writer.startElement("i", null);
                writer.writeAttribute("class", (Object)"mobi-dv-si", null);
                writer.endElement("i");
            }
            writer.endElement("th");
        }
        writer.endElement("tr");
        writer.endElement("thead");
        if (writeTable) {
            writer.endElement("table");
        }
    }

    private void encodeFooters(ResponseWriter writer, DataViewColumnsModel columnModel, DataViewDataModel dataModel, boolean writeTable) throws IOException {
        if (writeTable) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"mobi-dv-foot", null);
        }
        writer.startElement("tfoot", null);
        writer.startElement("tr", null);
        IndexedIterator columnIter = columnModel.iterator();
        while (columnIter.hasNext()) {
            DataViewColumnModel column = (DataViewColumnModel)columnIter.next();
            int index = columnIter.getIndex();
            if (!column.isRendered()) continue;
            writer.startElement("td", null);
            String className = this.getColumnStyleClass(column, index);
            writer.writeAttribute("class", (Object)className, null);
            if (column.getFooterText() != null) {
                writer.write(column.getFooterText());
            }
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tfoot");
        if (writeTable) {
            writer.endElement("table");
        }
    }

    private String getColumnStyleClass(DataViewColumnModel column, int index) {
        String colStyleClass = column.getStyleClass();
        String className = "mobi-dv-c-" + index;
        if (colStyleClass != null) {
            className = className + " " + colStyleClass;
        }
        return className;
    }

    private void encodeRows(FacesContext context, ResponseWriter writer, DataView dataView, String var, DataViewColumnsModel columnModel, DataViewDataModel dataModel) throws IOException {
        String dvId = dataView.getClientId();
        ELContext elContext = context.getELContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        String clientId = dvId;
        String bodyClass = "mobi-dv-body";
        if (dataView.isRowStroke()) {
            bodyClass = bodyClass + " stroke";
        }
        if (dataView.isRowStripe()) {
            bodyClass = bodyClass + " stripe";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"overthrow", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)bodyClass, null);
        if (columnModel.hasHeaders()) {
            this.encodeHeaders(writer, columnModel, dataModel, false);
        }
        writer.startElement("tbody", null);
        List<UIComponent> detailHolders = this.getDetailHolders((UIComponent)dataView.getDetails());
        String rowIndexVar = dataView.getRowIndexVar();
        Integer activeRowIndex = dataView.getActiveRowIndex();
        int selectedRowIndex = activeRowIndex == null ? -1 : activeRowIndex;
        IndexedIterator dataModelIterator = dataModel.iterator();
        while (dataModelIterator.hasNext()) {
            Object rowData = dataModelIterator.next();
            int index = dataModelIterator.getIndex();
            requestMap.put(var, rowData);
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, index);
            }
            writer.startElement("tr", null);
            writer.writeAttribute("id", (Object)(clientId + "_" + dataModelIterator.getIndex()), null);
            writer.writeAttribute("data-index", (Object)index, null);
            if (index == selectedRowIndex) {
                writer.writeAttribute("class", (Object)"ui-state-active", null);
            }
            if (dataView.getClientBehaviors().isEmpty()) {
                writer.writeAttribute("data-state", (Object)this.encodeRowDetailString(context, dvId, detailHolders), null);
            }
            IndexedIterator columnModelIterator = columnModel.iterator();
            while (columnModelIterator.hasNext()) {
                this.writeColumn(writer, elContext, (DataViewColumnModel)columnModelIterator.next(), columnModelIterator.getIndex(), dataView);
            }
            writer.endElement("tr");
        }
        requestMap.remove(var);
        if (rowIndexVar != null) {
            requestMap.remove(rowIndexVar);
        }
        writer.endElement("tbody");
        if (columnModel.hasFooters()) {
            this.encodeFooters(writer, columnModel, dataModel, false);
        }
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeColumn(ResponseWriter writer, ELContext elContext, DataViewColumnModel column, int index, DataView dataView) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ValueExpression ve = column.getValueExpression();
        Object value = ve == null ? column.getValue() : ve.getValue(elContext);
        String type = column.getType();
        boolean escape = column.isEscape();
        String colClass = this.getColumnStyleClass(column, index);
        writer.startElement("td", null);
        if (type.equals("bool")) {
            colClass = colClass + " mobi-dv-bool";
            writer.startElement("i", null);
            if (value != null) {
                Boolean bval = (Boolean)value;
                String resUrl = bval != false ? "fa fa-check-square-o" : "fa fa-square-o";
                writer.writeAttribute("class", (Object)resUrl, null);
            }
            writer.endElement("i");
        } else if (type.equals("date")) {
            writer.write(this.getDateFormat(column).format(value));
        } else if (type.equals("image")) {
            writer.startElement("img", null);
            if (value != null) {
                writer.writeAttribute("src", (Object)value.toString(), null);
            }
            writer.endElement("img");
        } else if (type.equals("list")) {
            writer.startElement("ul", null);
            if (value != null && value instanceof List) {
                for (Object i : (List)value) {
                    writer.startElement("li", null);
                    if (escape) {
                        writer.writeText((Object)i.toString(), (UIComponent)dataView, null);
                    } else {
                        writer.write(i.toString());
                    }
                    writer.endElement("li");
                }
            }
            writer.endElement("ul");
        } else if (value != null) {
            if (escape) {
                writer.writeText((Object)value.toString(), (UIComponent)dataView, null);
            } else {
                writer.write(value.toString());
            }
        }
        writer.writeAttribute("class", (Object)colClass, null);
        writer.endElement("td");
    }

    private DateFormat getDateFormat(DataViewColumnModel column) {
        DateFormat df;
        String pattern = column.getDatePattern();
        String type = column.getDateType();
        TimeZone timeZone = column.getTimeZone();
        Locale locale = column.getLocale();
        Integer dateStyle = column.getTimeStyle();
        Integer timeStyle = column.getDateStyle();
        if (pattern == null && type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (pattern != null) {
            df = new SimpleDateFormat(pattern, locale);
        } else if (type.equals("both")) {
            df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        } else if (type.equals("date")) {
            df = DateFormat.getDateInstance(dateStyle, locale);
        } else if (type.equals("time")) {
            df = DateFormat.getTimeInstance(timeStyle, locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        df.setLenient(false);
        df.setTimeZone(timeZone);
        return df;
    }

    private String encodeRowDetailString(FacesContext context, String dvId, List<UIComponent> detailHolders) {
        StringBuilder detStr = new StringBuilder();
        Iterator<UIComponent> valueHolderIterator = detailHolders.iterator();
        while (valueHolderIterator.hasNext()) {
            this.appendUpdateString(dvId, detStr, context, valueHolderIterator);
        }
        return DOMUtils.escapeAnsi((String)detStr.toString());
    }

    private void appendUpdateString(String dvId, StringBuilder detStr, FacesContext context, Iterator<UIComponent> valueHolderIterator) {
        String cId = dvId + UINamingContainer.getSeparatorChar((FacesContext)context);
        ELContext elContext = context.getELContext();
        UIComponent vhComponent = valueHolderIterator.next();
        Set<String> propertyNames = this.getPropNames(vhComponent);
        boolean first = true;
        for (String prop : propertyNames) {
            ValueExpression ve = vhComponent.getValueExpression(prop);
            if (ve == null) continue;
            if (!first) {
                detStr.append("|");
            }
            String value = vhComponent instanceof ValueHolder && "value".equals(prop) ? ComponentUtils.getStringValueToRender((FacesContext)context, (UIComponent)vhComponent) : ve.getValue(elContext).toString();
            detStr.append(vhComponent.getClientId().replaceFirst(cId, "")).append("=");
            detStr.append(this.getDirective(vhComponent, prop)).append("=");
            detStr.append(value);
            first = false;
        }
        if (!first && valueHolderIterator.hasNext()) {
            detStr.append("|");
        }
    }

    private boolean instanceOf(Object x, List<Class> y) {
        Class<?> xc = x.getClass();
        for (Class c : y) {
            if (!c.isInstance(x)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getPropNames(UIComponent vhComponent) {
        if (vhComponent instanceof TextEntry) {
            return mobiTextEntryProperties;
        }
        if (vhComponent instanceof UICommand) {
            return uiCommandProperties;
        }
        if (vhComponent instanceof UIInput) {
            return uiInputProperties;
        }
        if (vhComponent instanceof UIOutput) {
            return uiOutputProperties;
        }
        return emptySet;
    }

    private String getDirective(UIComponent c, String propertyName) {
        if (propertyName == "value") {
            if (this.instanceOf(c, htmlValueHolders) || this.isHtmlValueHolder(c)) {
                return "html";
            }
            if (this.instanceOf(c, attrValueHolders)) {
                return "attr=value";
            }
            if (c instanceof HtmlSelectBooleanCheckbox) {
                return "attr=checked";
            }
        }
        return "attr=" + propertyName;
    }

    private boolean isHtmlValueHolder(UIComponent c) {
        TextEntry textEntry;
        return c instanceof TextEntry && (textEntry = (TextEntry)c).getType().equals("textarea");
    }

    private void encodeDetails(FacesContext context, ResponseWriter writer, DataView dataView) throws IOException {
        String dvId = dataView.getClientId();
        DataViewDetails details = dataView.getDetails();
        Integer index = dataView.getActiveRowIndex();
        String var = dataView.getVar();
        String rowIndexVar = dataView.getRowIndexVar();
        String activationMode = dataView.getClientBehaviors().isEmpty() ? "client" : "server";
        boolean active = "client".equals(activationMode) || "server".equals(activationMode) && index != null && index >= 0;
        Map requestMap = context.getExternalContext().getRequestMap();
        if (index != null && index >= 0) {
            DataViewDataModel dataModel = dataView.getDataModel();
            requestMap.put(var, dataModel.getDataByIndex(index));
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, index);
            }
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(dvId + "_det"), null);
        writer.writeAttribute("class", (Object)"mobi-dv-det ui-widget ui-widget-content", null);
        if (details != null && active) {
            details.encodeAll(context);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(dvId + "_active"), null);
        writer.writeAttribute("name", (Object)(dvId + "_active"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        if (index == null) {
            writer.writeAttribute("value", (Object)"", null);
        } else {
            writer.writeAttribute("value", (Object)index, null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(dvId + "_indexScript"), null);
        writer.startElement("script", null);
        writer.writeText((Object)("document.getElementById('" + dvId + "_det" + "').setAttribute('data-index'," + index + ");"), null);
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("div");
        requestMap.remove(var);
        if (rowIndexVar != null) {
            requestMap.remove(rowIndexVar);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<UIComponent> getDetailHolders(UIComponent component) {
        if (component.getChildCount() > 0) {
            ArrayList<UIComponent> valueHolders = new ArrayList<UIComponent>();
            for (UIComponent child : component.getChildren()) {
                if (child instanceof ValueHolder) {
                    valueHolders.add(child);
                }
                if (child instanceof UICommand) {
                    valueHolders.add(child);
                }
                valueHolders.addAll(this.getDetailHolders(child));
            }
            return valueHolders;
        }
        return Collections.emptyList();
    }
}

