/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.sms;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.autocompleteentry.AutoCompleteEntry;
import org.icefaces.ace.component.combobox.ComboBox;
import org.icefaces.ace.component.maskedentry.MaskedEntry;
import org.icefaces.ace.component.textareaentry.TextAreaEntry;
import org.icefaces.ace.component.textentry.TextEntry;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.mobi.component.sms.Sms;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class SmsRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(SmsRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        Sms sms = (Sms)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = sms.getClientId();
        UIComponent fallbackFacet = sms.getFacet("fallback");
        writer.startElement("span", (UIComponent)sms);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"mobi-sms", null);
        writer.startElement("button", (UIComponent)sms);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.writeAttribute("type", (Object)"button", null);
        String style = sms.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = sms.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.writeAttribute("tabindex", (Object)sms.getTabindex(), null);
        try {
            if (sms.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            String number = this.determineNumber(sms);
            String message = this.determineMessage(sms);
            String launchFailed = fallbackFacet != null ? "ice.mobi.fallback.setupLaunchFailed('" + clientId + "_button','" + clientId + "_fallback');" : "";
            String script = launchFailed + "bridgeit.sms(" + number + ", " + message + ");";
            writer.writeAttribute("onclick", (Object)script, null);
        }
        catch (Exception e) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
            logger.info("ERROR: mobi:sms requires non null number and message attributes. Consider using numberInputId and messageInputId instead.");
            FacesMessage fm = new FacesMessage(" ERROR: mobi:sms requires non null values for number and message attributes. Consider using numberInputId and messageInputId instead.");
            facesContext.addMessage(clientId, fm);
        }
        writer.startElement("span", (UIComponent)sms);
        writer.write(sms.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", (UIComponent)sms);
        writer.startElement("script", (UIComponent)sms);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("new ice.mobi.button('" + clientId + "_button');");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        if (fallbackFacet != null) {
            writer.startElement("span", (UIComponent)sms);
            writer.writeAttribute("id", (Object)(clientId + "_fallback"), null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            if (fallbackFacet.isRendered()) {
                fallbackFacet.encodeAll(facesContext);
            }
            writer.endElement("span");
        }
        writer.startElement("script", (UIComponent)sms);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("if (!bridgeit.isSupportedPlatform('sms') && document.getElementById('" + clientId + "_fallback')) {"), null);
        writer.writeText((Object)("document.getElementById('" + clientId + "_button').style.display='none';"), null);
        writer.writeText((Object)("document.getElementById('" + clientId + "_fallback').style.display='inline';"), null);
        writer.writeText((Object)"}", null);
        writer.endElement("script");
        writer.endElement("span");
    }

    private String determineNumber(Sms sms) {
        String numberInputId = sms.getNumberInputId();
        String number = numberInputId != null ? "document.getElementById('" + this.determineId(numberInputId) + "').value" : "'" + SmsRenderer.escapeString(sms.getNumber()) + "'";
        return number;
    }

    private String determineMessage(Sms sms) {
        String messageInputId = sms.getMessageInputId();
        String message = messageInputId != null ? "document.getElementById('" + this.determineId(messageInputId) + "').value" : "'" + SmsRenderer.escapeString(sms.getMessage()) + "'";
        return message;
    }

    private String determineId(String id) {
        String result;
        UIComponent component = ComponentUtils.findComponent((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), (String)id);
        if (component != null) {
            String clientId = component.getClientId(FacesContext.getCurrentInstance());
            result = component instanceof AutoCompleteEntry ? clientId + "_input" : (component instanceof ComboBox ? clientId + "_input" : (component instanceof MaskedEntry ? clientId + "_field" : (component instanceof TextAreaEntry ? clientId + "_input" : (component instanceof TextEntry ? clientId + "_input" : clientId))));
        } else {
            result = id;
        }
        return result;
    }

    public static String escapeString(String value) {
        StringBuilder sb = new StringBuilder();
        block10: for (int idx = 0; idx < value.length(); ++idx) {
            char c = value.charAt(idx);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

