/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.viewmanager;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.viewmanager.View;
import org.icefaces.mobi.component.viewmanager.ViewManager;

public class ViewRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        View view = (View)uiComponent;
        ViewManager vm = (ViewManager)uiComponent.getParent();
        this.validate(view);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)view);
        writer.writeAttribute("id", (Object)view.getClientId(), null);
        writer.writeAttribute("data-view", (Object)(view.isSplash() ? "splash" : view.getId()), null);
        String title = view.getTitle();
        if (title == null) {
            title = vm.getTitle();
        }
        if (title != null) {
            writer.writeAttribute("data-title", (Object)title, null);
        }
        writer.writeAttribute("class", (Object)("mobi-vm-view" + (view.isSplash() ? " mobi-vm-splash" : "")), null);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(view.getClientId() + "_content"), null);
        writer.writeAttribute("class", (Object)("mobi-vm-view-content " + view.getStyleClass()), null);
        writer.writeAttribute("style", (Object)view.getStyle(), null);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(view.getClientId() + "_inner"), null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        View view = (View)uiComponent;
        ViewManager vm = (ViewManager)uiComponent.getParent();
        if (vm.isClientSide() || view.isSplash() || vm.getSelectedView() == view) {
            Utils.renderChildren((FacesContext)facesContext, (UIComponent)uiComponent);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        View view = (View)uiComponent;
        ViewManager vm = (ViewManager)uiComponent.getParent();
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"mobi-vm-nav-bar", null);
        List<View> views = view.getNavBarItemsToRender();
        String width = view.getNavBarItemChildWidth();
        String selected = vm.getSelected();
        for (View v : views) {
            this.renderNavBarItem(writer, v.getId(), width, selected.equals(v.getId()), v.getMenuIcon(), v.getTitle());
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    private void validate(View view) {
        if (!(view.getParent() instanceof ViewManager)) {
            throw new IllegalStateException("The view component must be a child of the viewManager component");
        }
    }

    private void renderNavBarItem(ResponseWriter writer, String view, String width, boolean active, String icon, String title) throws IOException {
        writer.startElement("a", null);
        writer.writeAttribute("style", (Object)("width: " + width), null);
        writer.writeAttribute("onclick", (Object)("ice.mobi.viewManager.showView('" + view + "', event);"), null);
        if (icon != null) {
            writer.startElement("i", null);
            writer.writeAttribute("class", (Object)("fa fa-" + icon), null);
            writer.endElement("i");
        }
        writer.write(title);
        writer.endElement("a");
    }
}

