/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.datespinner;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.datespinner.DateSpinner;
import org.icefaces.mobi.renderkit.InputRenderer;

public class DateSpinnerRenderer
extends InputRenderer {
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";
    private static final Logger logger = Logger.getLogger(DateSpinnerRenderer.class.getName());

    static boolean shouldUseNative(DateSpinner component) {
        return component.isUseNative() && Utils.getClientDescriptor().isHasNativeDatePicker();
    }

    public void decode(FacesContext context, UIComponent component) {
        String inputValue;
        boolean inputNull;
        DateSpinner dateSpinner = (DateSpinner)component;
        String clientId = dateSpinner.getClientId(context);
        if (dateSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        if (DateSpinnerRenderer.shouldUseNative(dateSpinner)) {
            inputField = clientId;
        }
        if ((inputNull = this.isValueBlank(inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField))) && dateSpinner.isRequired()) {
            ResourceBundle bundle = ComponentUtils.getComponentResourceBundle((FacesContext)FacesContext.getCurrentInstance(), (String)"org.icefaces.mobi.resources.messages");
            String validmessage = ComponentUtils.getLocalisedMessageFromBundle((ResourceBundle)bundle, (String)"org.icefaces.mobi.component.datespinner.", (String)"required", (String)"Validation Error, the date value for id {0} is required.");
            String errorMessage = MessageFormat.format(validmessage, dateSpinner.getClientId());
            FacesMessage message = new FacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            message.setSummary(errorMessage);
            message.setDetail(errorMessage);
            context.addMessage(clientId, message);
        }
        if (!inputNull && this.withindateRange(dateSpinner, inputValue)) {
            dateSpinner.setSubmittedValue(inputValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateSpinner spinner = (DateSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        spinner.setTouchEnabled(Utils.isTouchEventEnabled((FacesContext)context));
        String initialValue = ComponentUtils.getStringValueToRender((FacesContext)context, (UIComponent)component);
        ResourceBundle bundle = ComponentUtils.getComponentResourceBundle((FacesContext)FacesContext.getCurrentInstance(), (String)"org.icefaces.mobi.resources.messages");
        String message = ComponentUtils.getLocalisedMessageFromBundle((ResourceBundle)bundle, (String)"org.icefaces.mobi.component.datespinner.", (String)"yearRange", (String)"Year requires a value between {0} and {1}.");
        String errorMessage = MessageFormat.format(message, Integer.toString(spinner.getYearStart()), Integer.toString(spinner.getYearEnd()));
        if (DateSpinnerRenderer.shouldUseNative(spinner)) {
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)(clientId + "_nwrap"), null);
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"date", "type");
            this.renderResetSettings(context, component, "datespinner");
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            String styleClass = spinner.getStyleClass();
            String style = spinner.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            if (this.isValueBlank(initialValue)) {
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            String dateMin = String.valueOf(spinner.getYearStart()) + "-01-01T12:00:00";
            String dateEnd = String.valueOf(spinner.getYearEnd()) + "-12-31T12:00:00";
            writer.writeAttribute("min", (Object)dateMin, "min");
            writer.writeAttribute("max", (Object)dateEnd, "max");
            boolean noJs = false;
            if (readonly || disabled) {
                noJs = true;
            }
            if (!noJs && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                cbhCall = cbhCall.replace("\"", "'");
                writer.writeAttribute(event, (Object)("mobi.datespinner.inputNative('" + clientId + "'," + cbhCall + ", '" + errorMessage + "');"), null);
            }
            ComponentUtils.renderPassThroughAttributes((ResponseWriter)writer, (UIComponent)spinner, (String[])spinner.getCommonAttributeNames());
            writer.endElement("input");
            this.generateErrorMessageSpan(component, writer, clientId);
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)(clientId + "_useNativeInit"), null);
            writer.writeAttribute("class", (Object)"mobi-hidden", null);
            writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("mobi.datespinner.nativeInit('" + clientId + "'," + initialValue + " );");
            writer.endElement("script");
            writer.endElement("span");
            writer.endElement("div");
        } else {
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors, errorMessage);
            this.encodeScript(context, component, hasBehaviors, errorMessage);
            this.generateErrorMessageSpan(component, writer, clientId);
        }
    }

    private void generateErrorMessageSpan(UIComponent component, ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)(clientId + "_error"), null);
        writer.writeAttribute("style", (Object)"display:none;", null);
        writer.endElement("span");
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors, String errorMessage) throws IOException {
        String style;
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner dateSpinner = (DateSpinner)uiComponent;
        String clientId = dateSpinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = dateSpinner.isTouchEnabled() ? TOUCH_START_EVENT : CLICK_EVENT;
        StringBuilder builder = new StringBuilder(255);
        StringBuilder builder2 = new StringBuilder(255);
        String inputCallStart = "mobi.datespinner.inputSubmit('";
        String jsCallStart = "mobi.datespinner.select('";
        builder2.append(clientId).append("',{ event:'" + eventStr + "'");
        builder2.append(", yrMin:" + dateSpinner.getYearStart());
        builder2.append(", yrMax:" + dateSpinner.getYearEnd());
        builder2.append(", errorMessage: '" + errorMessage + "'");
        if (hasBehaviors) {
            String behaviors = this.buildAjaxRequest(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder2.append(", behaviors: " + behaviors);
        }
        builder2.append("});");
        boolean disabledOrReadonly = false;
        boolean disabled = dateSpinner.isDisabled();
        boolean readonly = dateSpinner.isReadonly();
        if (readonly || disabled) {
            disabledOrReadonly = true;
        }
        builder.append(jsCallStart).append((CharSequence)builder2);
        StringBuilder inputCall = new StringBuilder(inputCallStart).append((CharSequence)builder2);
        String jsCall = builder.toString();
        writer.startElement("span", uiComponent);
        String styleClass = dateSpinner.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderResetSettings(context, uiComponent, "datespinner");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-date-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        if (!disabledOrReadonly) {
            writer.writeAttribute("onblur", (Object)inputCall.toString(), null);
        }
        if ((style = dateSpinner.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        StringBuilder classNames = new StringBuilder("mobi-input-text");
        writer.writeAttribute("class", (Object)classNames.toString(), "class");
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-date-popup-btn", null);
        if (dateSpinner.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (!disabledOrReadonly) {
            writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-bg-inv", "class");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-container-inv ui-widget ui-widget-content", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-title-container ui-widget-header", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"fa fa-calendar", null);
        writer.endElement("span");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-title", null);
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-container ui-widget-content", null);
        String pattern = this.findPattern(dateSpinner);
        if (pattern != null) {
            int yStart = pattern.toLowerCase().indexOf("y");
            int mStart = pattern.toLowerCase().indexOf("m");
            int dStart = pattern.toLowerCase().indexOf("d");
            if (yStart < mStart && mStart < dStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (yStart < dStart && dStart < mStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (dStart < mStart && mStart < yStart) {
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (mStart < dStart && dStart < yStart) {
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            }
        } else {
            this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
        }
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-submit-container ui-widget-content", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        if (!dateSpinner.isDisabled() && !dateSpinner.isReadonly()) {
            writer.writeAttribute(CLICK_EVENT, (Object)(jsCall + "return false;"), null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent, boolean hasBehaviors, String errorMessage) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner spinner = (DateSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int yrInt = spinner.getYearInt();
        int mnthInt = spinner.getMonthInt();
        int dateInt = spinner.getDayInt();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String cfg = "{";
        cfg = cfg + "yrInt:" + yrInt;
        cfg = cfg + ",mnthInt:" + mnthInt;
        cfg = cfg + ",dateInt:" + dateInt;
        cfg = cfg + ", format: '" + this.findPattern(spinner) + "'";
        cfg = cfg + ", yrMin: " + spinner.getYearStart();
        cfg = cfg + ", yrMax: " + spinner.getYearEnd();
        cfg = cfg + ", readonly: " + spinner.isReadonly();
        cfg = cfg + ",useNative: " + spinner.isUseNative();
        cfg = cfg + ", errorMessage: '" + errorMessage + "'";
        if (hasBehaviors) {
            cfg = cfg + this.encodeClientBehaviors(context, (ClientBehaviorHolder)spinner, "change").toString();
        }
        cfg = cfg + "}";
        writer.write("mobi.datespinner.init('" + clientId + "'," + cfg + ");");
        writer.endElement("script");
        writer.endElement("span");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateSpinner spinner = (DateSpinner)component;
        String submittedValue = String.valueOf(value);
        Converter converter = spinner.getConverter();
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (converter != null) {
            Object objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            String pattern = this.findPattern(spinner);
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            format.setTimeZone(spinner.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private void renderDayInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_dUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_dInt"), null);
        writer.write(String.valueOf(dateEntry.getDayInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_dDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderMonthInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(dateEntry.getMonthInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderYearInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        int yMin = dateEntry.getYearStart();
        int yMax = dateEntry.getYearEnd();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_yUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yUp('" + clientId + "'," + yMin + "," + yMax + ");return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_yInt"), null);
        writer.write(String.valueOf(dateEntry.getYearInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_yDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yDn('" + clientId + "'," + yMin + "," + yMax + ");return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void setIntValues(DateSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        int tempYear = cal.get(1);
        if (tempYear < spinner.getYearStart()) {
            tempYear = spinner.getYearStart();
        }
        if (tempYear > spinner.getYearEnd()) {
            tempYear = spinner.getYearEnd();
        }
        spinner.setYearInt(tempYear);
        spinner.setMonthInt(cal.get(2) + 1);
        spinner.setDayInt(cal.get(5));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error converting string input.", e);
        }
        return returnString;
    }

    private String encodeValue(DateSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        String pattern = this.findPattern(spinner);
        SimpleDateFormat df2 = new SimpleDateFormat(pattern);
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, pattern)) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", pattern, initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private void writePlusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-plus", null);
        writer.endElement("span");
    }

    private void writeMinusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-minus", null);
        writer.endElement("span");
    }

    private String findPattern(DateSpinner dateSpinner) {
        String pattern = dateSpinner.getPattern();
        Converter converter = dateSpinner.getConverter();
        if (converter != null && converter instanceof DateTimeConverter) {
            DateTimeConverter tmp = (DateTimeConverter)converter;
            pattern = tmp.getPattern();
        }
        if (null == pattern) {
            pattern = "yyyy-MM-dd";
        }
        return pattern;
    }

    private boolean withindateRange(DateSpinner spinner, String inputVal) {
        if (inputVal == null) {
            return false;
        }
        String pattern = this.findPattern(spinner);
        if (spinner.isUseNative()) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat df2 = new SimpleDateFormat(pattern);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (spinner.getTimeZone() != null) {
            TimeZone tz;
            Object zoneObj = spinner.getTimeZone();
            if (zoneObj instanceof TimeZone) {
                tz = (TimeZone)zoneObj;
                df2.setTimeZone(tz);
            } else if (zoneObj instanceof String) {
                tz = TimeZone.getTimeZone(zoneObj.toString());
                df2.setTimeZone(tz);
            }
        }
        try {
            Date dateObj = df2.parse(inputVal);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateObj);
            int tempYear = cal.get(1);
            if (tempYear >= spinner.getYearStart() && tempYear <= spinner.getYearEnd()) {
                return true;
            }
            logger.info(" Year value of " + tempYear + " must be within yearStart " + spinner.getYearStart() + " and yearEnd " + spinner.getYearEnd() + " attribute values");
            return false;
        }
        catch (ParseException pe) {
            if (logger.isLoggable(Level.FINE)) {
                logger.info(" unable to parse date to check year range");
            }
            return false;
        }
    }
}

