/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.viewmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.icefaces.mobi.component.viewmanager.View;
import org.icefaces.mobi.component.viewmanager.ViewManagerBase;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class ViewManager
extends ViewManagerBase {
    private static final Logger LOG = Logger.getLogger(ViewManager.class.getName());
    public static final String STYLECLASS = "mobi-vm";
    public static final String MENU_ID = "mobiViewManagerMenu";
    public static final String TRANSITION_TYPE_VERTICAL = "vertical";
    public static final String TRANSITION_TYPE_HORIZONTAL = "horizontal";
    public static final String TRANSITION_TYPE_FLIP = "flip";
    public static final String TRANSITION_TYPE_FADE = "fade";
    public static final String TRANSITION_TYPE_PAGETURN = "pageturn";
    private static List<String> TRANSITION_TYPES = new ArrayList<String>();

    public boolean isCanGoBack() {
        return this.getHistory().size() > 1;
    }

    public void goBack(AjaxBehaviorEvent evt) {
        String prev;
        if (this.getHistory().size() > 1 && (prev = this.getHistoryStack().pop()) != null) {
            this.setSelected(prev);
        }
    }

    @Override
    public void setSelected(String selected) {
        super.setSelected(selected);
        Stack<String> history = this.getHistory();
        if (history.size() == 1 && ((String)history.get(0)).equals(selected)) {
            return;
        }
        if (history.size() > 1 && this.getHistory().contains(selected)) {
            Stack newHistory = new Stack();
            newHistory.addAll(this.getHistory().subList(0, this.getHistory().indexOf(selected) + 1));
            this.setHistory(newHistory);
        } else {
            this.getHistory().push(selected);
        }
    }

    @Override
    public String getSelected() {
        String selected = super.getSelected();
        if (selected == null || selected.length() == 0) {
            selected = MENU_ID;
            super.setSelected(selected);
        }
        return selected;
    }

    @Override
    public void setTransitionType(String transitionType) {
        if (!TRANSITION_TYPES.contains(transitionType)) {
            LOG.warning("invalid transitionType '" + transitionType + "', reverting to default '" + TRANSITION_TYPE_HORIZONTAL + "'");
            transitionType = TRANSITION_TYPE_HORIZONTAL;
        }
        super.setTransitionType(transitionType);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        String view = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId() + "_selected");
        if (view != null && !view.equals(this.getSelected())) {
            this.setSelected(view);
        }
    }

    public View getSelectedView() {
        String selected = this.getSelected();
        if (selected == null || selected.length() == 0) {
            return null;
        }
        return this.getView(selected);
    }

    public View getView(String id) {
        List children = this.getChildren();
        for (UIComponent child : children) {
            View view = (View)child;
            if (!view.getId().equals(id)) continue;
            return view;
        }
        return null;
    }

    @Override
    public Stack<String> getHistory() {
        Stack<String> history = super.getHistory();
        if (history == null || history.size() == 0) {
            history = new Stack<String>();
            history.add(this.getSelected());
            this.setHistory(history);
        }
        return history;
    }

    public String getHistoryAsJSON() {
        String h = "[";
        for (int i = 0; i < this.getHistory().size(); ++i) {
            String v = (String)this.getHistoryStack().get(i);
            h = h + "'" + v + "'";
            if (i >= this.getHistory().size() - 1) continue;
            h = h + ",";
        }
        h = h + "]";
        return h;
    }

    public Stack<String> getHistoryStack() {
        return this.getHistory();
    }

    static {
        TRANSITION_TYPES.add(TRANSITION_TYPE_HORIZONTAL);
        TRANSITION_TYPES.add(TRANSITION_TYPE_VERTICAL);
        TRANSITION_TYPES.add(TRANSITION_TYPE_FLIP);
        TRANSITION_TYPES.add(TRANSITION_TYPE_FADE);
        TRANSITION_TYPES.add(TRANSITION_TYPE_PAGETURN);
    }
}

