/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.mobi.renderkit.InlineScriptEventListener;
import org.icefaces.util.EnvUtils;

public class CoreRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(CoreRenderer.class.getName());

    protected void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected String getActionURL(FacesContext facesContext) {
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
        return facesContext.getExternalContext().encodeActionURL(actionURL);
    }

    protected String getResourceURL(FacesContext facesContext, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        return facesContext.getExternalContext().encodeResourceURL(url);
    }

    protected String getEncodedURL(FacesContext facesContext, String type, String baseUrl, Map parameters) {
        if (type != null) {
            type = type.toLowerCase();
            ExternalContext externalContext = facesContext.getExternalContext();
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            if (type.equals("action")) {
                String viewUrl = viewHandler.getActionURL(facesContext, baseUrl);
                return externalContext.encodeActionURL(viewUrl);
            }
            if (type.equals("partialaction")) {
                String viewUrl = viewHandler.getActionURL(facesContext, baseUrl);
                return externalContext.encodePartialActionURL(viewUrl);
            }
            if (type.equals("bookmarkable")) {
                String viewUrl = viewHandler.getBookmarkableURL(facesContext, baseUrl, parameters, false);
                return externalContext.encodeBookmarkableURL(viewUrl, parameters);
            }
            if (type.equals("redirect")) {
                String viewUrl = viewHandler.getRedirectURL(facesContext, baseUrl, parameters, false);
                return externalContext.encodeRedirectURL(viewUrl, parameters);
            }
            if (type.equals("resource")) {
                if (baseUrl.contains("/javax.faces.resource")) {
                    return baseUrl;
                }
                String viewUrl = viewHandler.getResourceURL(facesContext, baseUrl);
                return externalContext.encodeResourceURL(viewUrl);
            }
        }
        return baseUrl;
    }

    protected String getResourceRequestPath(FacesContext facesContext, String resourceName) {
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, "icefaces.mobi");
        return resource.getRequestPath();
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public boolean isAjaxRequest(FacesContext facesContext) {
        return facesContext.getPartialViewContext().isAjaxRequest();
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public String getEscapedClientId(String clientId) {
        return clientId.replaceAll(":", "\\\\\\\\:");
    }

    public String convertClientId(FacesContext context, String clientId) {
        boolean compressID = EnvUtils.isCompressIDs((FacesContext)context);
        if (!compressID) {
            return clientId;
        }
        long extendedHash = clientId.hashCode();
        return Long.toString(extendedHash, 36);
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected String escapeText(String value) {
        return value == null ? "" : value.replaceAll("'", "\\\\'");
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component, JSONBuilder jb) throws IOException {
        Map behaviorEvents = component.getClientBehaviors();
        if (behaviorEvents.isEmpty()) {
            return;
        }
        String clientId = ((UIComponent)component).getClientId(context);
        List params = Collections.emptyList();
        jb.beginMap("behaviors");
        ArrayList sortedBehaviourList = new ArrayList(behaviorEvents.keySet());
        Collections.sort(sortedBehaviourList);
        for (String event : sortedBehaviourList) {
            String domEvent = this.getDomEvent(event);
            ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
            List cbList = (List)behaviorEvents.get(event);
            Boolean writeArray = false;
            JSONBuilder cbJson = JSONBuilder.create();
            if (cbList.size() > 1) {
                writeArray = true;
                cbJson.beginArray();
            }
            for (ClientBehavior cb : cbList) {
                String script;
                if (cb instanceof AjaxBehavior || (script = cb.getScript(cbc)) == null) continue;
                if (writeArray.booleanValue()) {
                    cbJson.item(script, false);
                    continue;
                }
                jb.entry(domEvent, script, true);
            }
            if (!writeArray.booleanValue()) continue;
            cbJson.endArray();
            jb.entry(domEvent, cbJson.toString(), true);
        }
        jb.endMap();
    }

    private String getDomEvent(String event) {
        String domEvent = event;
        if (event.equalsIgnoreCase("valueChange")) {
            domEvent = "change";
        } else if (event.equalsIgnoreCase("action")) {
            domEvent = "click";
        }
        return domEvent;
    }

    protected boolean themeForms() {
        FacesContext context = FacesContext.getCurrentInstance();
        String value = context.getExternalContext().getInitParameter("org.icefaces.ace.themeForms");
        return value == null ? true : Boolean.valueOf(value);
    }

    protected void addToAutoUpdate(String clientId) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map viewMap = context.getViewRoot().getViewMap();
        HashSet<String> autoUpdateIds = (HashSet<String>)viewMap.get("org.icefaces.ace.autoUpdate");
        if (autoUpdateIds == null) {
            autoUpdateIds = new HashSet<String>();
            autoUpdateIds.add(clientId);
        }
        viewMap.put("org.icefaces.ace.autoUpdate", autoUpdateIds);
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component, null);
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component, String proxyClientId) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviors.isEmpty() || behaviorEvent == null) {
            return;
        }
        List behaviorsForEvent = (List)behaviors.get(behaviorEvent);
        if (behaviorsForEvent != null && !behaviorsForEvent.isEmpty()) {
            String clientId;
            String behaviorSource = (String)params.get("javax.faces.source");
            String string = clientId = proxyClientId == null ? component.getClientId() : proxyClientId;
            if (behaviorSource != null && behaviorSource.equals(clientId)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    protected StringBuilder encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component, String eventDef) throws IOException {
        StringBuilder sb = new StringBuilder(255);
        Map eventBehaviors = component.getClientBehaviors();
        if (!eventBehaviors.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            sb.append(",behaviors:{");
            Iterator eventIterator = eventBehaviors.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event = (String)eventIterator.next();
                if (null == event) {
                    event = eventDef;
                }
                String domEvent = this.getDomEvent(event);
                ClientBehaviorContext cbContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
                StringBuilder sb2 = new StringBuilder(255);
                for (ClientBehavior behavior : (List)eventBehaviors.get(event)) {
                    String script = behavior.getScript(cbContext);
                    if (script == null) continue;
                    sb2.append(script);
                }
                String scripts = sb2.toString();
                if (scripts.length() > 0) {
                    sb.append(domEvent + ":");
                    sb.append(scripts);
                }
                if (!eventIterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        return sb;
    }

    protected void writeJavascriptFile(FacesContext facesContext, UIComponent component, String JS_NAME, String JS_MIN_NAME, String JS_LIBRARY, String JS2_NAME, String JS2_MIN_NAME, String JS2_LIB) throws IOException {
        String src;
        Resource jsFile;
        String jsFname;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_libJS"), "id");
        if (!this.isScriptLoaded(facesContext, JS_NAME)) {
            jsFname = JS_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS_MIN_NAME;
            }
            jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
            src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS_NAME);
        }
        if (!this.isScriptLoaded(facesContext, JS2_NAME)) {
            jsFname = JS2_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS2_MIN_NAME;
            }
            jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS2_LIB);
            src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS2_NAME);
        }
        writer.endElement("span");
    }

    protected void writeJavascriptFile(FacesContext facesContext, UIComponent component, String JS_NAME, String JS_MIN_NAME, String JS_LIBRARY) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_libJS"), "id");
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        if (!this.isScriptLoaded(facesContext, JS_NAME)) {
            String jsFname = JS_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS_MIN_NAME;
            }
            Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
            String src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS_NAME);
        }
        writer.endElement("span");
    }

    protected void setScriptLoaded(FacesContext facesContext, String JS_NAME) {
        InlineScriptEventListener.setScriptLoaded(facesContext, JS_NAME);
    }

    protected boolean isScriptLoaded(FacesContext facesContext, String JS_NAME) {
        return InlineScriptEventListener.isScriptLoaded(facesContext, JS_NAME);
    }

    protected String buildAjaxRequest(FacesContext context, ClientBehaviorHolder component, String inEvent) {
        Map behaviorEvents = component.getClientBehaviors();
        if (behaviorEvents.isEmpty()) {
            return null;
        }
        String clientId = ((UIComponent)component).getClientId(context);
        StringBuilder req = new StringBuilder();
        List params = Collections.emptyList();
        Iterator eventIterator = behaviorEvents.keySet().iterator();
        while (eventIterator.hasNext()) {
            String event;
            String domEvent = event = (String)eventIterator.next();
            if (null != inEvent) {
                domEvent = inEvent;
            }
            domEvent = this.getDomEvent(event);
            if (behaviorEvents.get(event) == null) {
                return null;
            }
            for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                ClientBehaviorContext cbc;
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params));
                if (script == null) continue;
                req.append(script);
            }
            if (!eventIterator.hasNext()) continue;
            req.append(",");
        }
        return req.toString();
    }

    public ResourceBundle getComponentResourceBundle(FacesContext context, String ACE_MESSAGES_BUNDLE) {
        Locale locale = context.getViewRoot().getLocale();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String bundleName = context.getApplication().getMessageBundle();
        if (classLoader == null) {
            classLoader = bundleName.getClass().getClassLoader();
        }
        if (bundleName == null) {
            bundleName = ACE_MESSAGES_BUNDLE;
        }
        return ResourceBundle.getBundle(bundleName, locale, classLoader);
    }

    public static String getLocalisedMessageFromBundle(ResourceBundle bundle, String MESSAGE_KEY_PREFIX, String key, String defaultValue) {
        String label;
        block3: {
            if (null == bundle) {
                return defaultValue;
            }
            label = defaultValue;
            try {
                label = bundle.getString(MESSAGE_KEY_PREFIX + key);
            }
            catch (MissingResourceException mre) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.fine(" BUNDLE missing property : " + key + " defaultValue used : " + defaultValue);
            }
        }
        return label;
    }
}

