/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.ace.util.Utils;
import org.icefaces.util.EnvUtils;

public class SXUtils {
    public static final String SX_UPLOAD = "sxUploads";
    public static final String SX_UPLOAD_PROGRESS = "sxUploadProgress";
    public static final String SX_THUMB_MAP = "sxUploadThumbMap";
    public static final String SESSION_KEY_SX_REGISTERED = "sxRegistered";
    public static final String USER_AGENT_SX_PART = "ICEmobile-SX";
    public static final String USER_AGENT_SX_FULL = "HyperBrowser-ICEmobile-SX/1.0";
    public static final String COOKIE_FORMAT = "org.icemobile.cookieformat";

    public static String getRegisterSXURL(HttpServletRequest request, String uploadPath) {
        String sessionID = SXUtils.getSessionIdCookie(request);
        String redirectParm = "&r=" + Utils.getBaseURL((ServletRequest)request);
        String forward = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        if (forward == null) {
            forward = request.getRequestURI().substring(request.getContextPath().length() + 1);
        } else if (forward.startsWith("/")) {
            forward = forward.substring(1);
        }
        String params = "";
        if (request.getQueryString() != null) {
            params = "?" + request.getQueryString();
            try {
                params = URLEncoder.encode(params, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        redirectParm = redirectParm + forward + params;
        String jsessionParam = "&JSESSIONID=" + sessionID;
        String uploadParam = "&u=" + Utils.getBaseURL((ServletRequest)request) + uploadPath;
        String url = "icemobile:c=register" + redirectParm + jsessionParam + uploadParam;
        return url;
    }

    public static String getRegisterSXURL(HttpServletRequest request) {
        String sessionID = SXUtils.getSessionIdCookie(request);
        String redirectParm = "&r=" + Utils.getBaseURL((ServletRequest)request);
        String forward = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        if (forward == null) {
            forward = "";
        } else if (forward.startsWith("/")) {
            forward = forward.substring(1);
        }
        String params = "";
        if (request.getQueryString() != null) {
            params = "?" + request.getQueryString();
        }
        redirectParm = redirectParm + forward + params;
        String jsessionParam = "&JSESSIONID=" + sessionID;
        String uploadParam = "&u=" + Utils.getBaseURL((ServletRequest)request) + "/icemobile";
        String url = "icemobile:c=register" + redirectParm + jsessionParam + uploadParam;
        return url;
    }

    public static boolean isSXRegistered(HttpServletRequest request) {
        return EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).getAttribute(SESSION_KEY_SX_REGISTERED) == Boolean.TRUE || EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).getAttribute("iceAuxRequestMap") != null;
    }

    public static boolean isSXRequest(HttpServletRequest request) {
        String userAgent = Utils.getUserAgent((HttpServletRequest)request);
        return userAgent != null && userAgent.contains(USER_AGENT_SX_PART);
    }

    public static void setSXSessionKeys(HttpServletRequest request) {
        EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).setAttribute(SESSION_KEY_SX_REGISTERED, (Object)Boolean.TRUE);
        EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).setAttribute("com.icesoft.user-agent", (Object)USER_AGENT_SX_FULL);
    }

    public static int getAuxiliaryUploadProgress(HttpServletRequest request) {
        Integer progress = (Integer)EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).getAttribute(SX_UPLOAD_PROGRESS);
        if (null == progress) {
            return 0;
        }
        return progress;
    }

    public static Map<String, File> getAuxiliaryUploadMap(HttpServletRequest request) {
        HashMap map = (HashMap)EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).getAttribute(SX_UPLOAD);
        if (null == map) {
            map = new HashMap();
            EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).setAttribute(SX_UPLOAD, map);
        }
        return map;
    }

    public static String getICEmobileSXScript(HttpServletRequest request, String command, Map<String, String> params, String id, String sessionID, String uploadPath) {
        String uploadURL = Utils.getBaseURL((ServletRequest)request) + uploadPath;
        String fullCommand = command + "?id=" + id + SXUtils.encodeParams(params);
        String script = "window.location='icemobile:c=";
        try {
            script = script + URLEncoder.encode(fullCommand, "UTF-8") + "&r='+escape(window.location)+'";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (null != sessionID) {
            script = script + "&JSESSIONID=" + sessionID;
        }
        try {
            script = script + "&u=" + URLEncoder.encode(uploadURL, "UTF-8") + "'";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return script;
    }

    public static String encodeParams(Map<String, String> params) {
        if (null == params) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String name : params.keySet()) {
            result.append("&");
            result.append(URLEncoder.encode(name)).append("=");
            result.append(URLEncoder.encode(params.get(name)));
        }
        return result.toString();
    }

    public static String getICEmobileRegisterSXScript(HttpServletRequest request, String uploadPath) {
        String sessionID = SXUtils.getSessionIdCookie(request);
        String uploadURL = Utils.getBaseURL((ServletRequest)request) + uploadPath;
        return "ice.registerAuxUpload('" + sessionID + "','" + uploadURL + "');";
    }

    public static void setAuxUploadProgress(int progress, HttpSession session) {
        if (progress < 1 || progress > 99) {
            progress = 0;
        }
        session.setAttribute(SX_UPLOAD_PROGRESS, (Object)progress);
    }

    public static String getSessionIdCookie(HttpServletRequest request) {
        String sessionID = null;
        String cookieFormat = null;
        HttpSession httpSession = EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance());
        if (null == httpSession) {
            return sessionID;
        }
        sessionID = httpSession.getId();
        cookieFormat = EnvUtils.getSafeContext((FacesContext)FacesContext.getCurrentInstance()).getInitParameter(COOKIE_FORMAT);
        if (null == cookieFormat) {
            return sessionID;
        }
        StringBuilder out = new StringBuilder();
        Formatter cookieFormatter = new Formatter(out);
        cookieFormatter.format(cookieFormat, sessionID);
        cookieFormatter.close();
        return out.toString();
    }

    public static Map<String, File> getSXUploadThumbMap(HttpServletRequest request) {
        HashMap map = (HashMap)EnvUtils.getSafeSession((FacesContext)FacesContext.getCurrentInstance()).getAttribute(SX_THUMB_MAP);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }
}

