/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.View;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class MultiViewServer
implements Server {
    private int viewCount = 0;
    private Map views;
    private ViewQueue asynchronouslyUpdatedViews;
    private String sessionID;
    private Configuration configuration;
    private SessionDispatcher.Monitor sessionMonitor;
    private HttpSession session;
    private ResourceDispatcher resourceDispatcher;
    private String blockingRequestHandlerContext;
    private Authorization authorization;

    public MultiViewServer(HttpSession session, String sessionID, SessionDispatcher.Monitor sessionMonitor, Map views, ViewQueue asynchronouslyUpdatedViews, Configuration configuration, ResourceDispatcher resourceDispatcher, String blockingRequestHandlerContext, Authorization authorization) {
        this.session = session;
        this.sessionID = sessionID;
        this.sessionMonitor = sessionMonitor;
        this.views = views;
        this.asynchronouslyUpdatedViews = asynchronouslyUpdatedViews;
        this.configuration = configuration;
        this.resourceDispatcher = resourceDispatcher;
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
        this.authorization = authorization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request) throws Exception {
        View view;
        Map map = this.views;
        synchronized (map) {
            String viewIdentifier;
            view = request.containsParameter("rvn") ? (MultiViewServer.isInteger(viewIdentifier = request.getParameter("rvn")) && this.views.containsKey(viewIdentifier) ? (View)this.views.get(viewIdentifier) : this.createView()) : this.createView();
        }
        try {
            this.sessionMonitor.touchSession();
            view.servePage(request);
        }
        finally {
            view.release();
        }
    }

    private View createView() throws Exception {
        String viewNumber = String.valueOf(++this.viewCount);
        View view = new View(viewNumber, this.sessionID, this.session, this.asynchronouslyUpdatedViews, this.configuration, this.sessionMonitor, this.resourceDispatcher, this.blockingRequestHandlerContext, this.authorization);
        this.views.put(viewNumber, view);
        return view;
    }

    public void shutdown() {
    }

    private static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

