/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.async.common.PushServerAdaptingServlet;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.PageTest;
import com.icesoft.faces.webapp.http.core.SendUpdatedViews;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.util.MonitorRunner;
import java.util.Collection;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushServerDetector
implements Server {
    private static final Log LOG = LogFactory.getLog((Class)PushServerDetector.class);
    private static final Object LOCK = new Object();
    private static ServerFactory factory;
    private static ServerFactory fallbackFactory;
    private Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PushServerDetector(HttpSession httpSession, String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient, PageTest pageTest) {
        if (factory == null) {
            Object object = LOCK;
            synchronized (object) {
                if (factory == null) {
                    if (messageServiceClient != null) {
                        factory = new PushServerAdaptingServletFactory();
                        fallbackFactory = new SendUpdatedViewsFactory();
                    } else {
                        factory = new SendUpdatedViewsFactory();
                    }
                }
            }
        }
        this.server = factory.newServer(httpSession, icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration, messageServiceClient, pageTest);
    }

    public void service(Request request) throws Exception {
        this.server.service(request);
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private static class SendUpdatedViewsFactory
    implements ServerFactory {
        private SendUpdatedViewsFactory() {
        }

        public Server newServer(HttpSession httpSession, String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient, PageTest pageTest) {
            return new SendUpdatedViews(icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration, pageTest);
        }
    }

    private static class PushServerAdaptingServletFactory
    implements ServerFactory {
        private PushServerAdaptingServletFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Server newServer(HttpSession httpSession, String icefacesID, Collection synchronouslyUpdatedViews, ViewQueue allUpdatedViews, MonitorRunner monitorRunner, Configuration configuration, MessageServiceClient messageServiceClient, PageTest pageTest) {
            try {
                return new PushServerAdaptingServlet(httpSession, icefacesID, synchronouslyUpdatedViews, allUpdatedViews, configuration, messageServiceClient);
            }
            catch (Exception exception) {
                LOG.warn((Object)"Failed to adapt to Push Server environment. Falling back to Push environment.", (Throwable)exception);
                Object object = LOCK;
                synchronized (object) {
                    factory = fallbackFactory;
                    fallbackFactory = null;
                }
                return factory.newServer(httpSession, icefacesID, synchronouslyUpdatedViews, allUpdatedViews, monitorRunner, configuration, messageServiceClient, pageTest);
            }
        }
    }

    private static interface ServerFactory {
        public Server newServer(HttpSession var1, String var2, Collection var3, ViewQueue var4, MonitorRunner var5, Configuration var6, MessageServiceClient var7, PageTest var8);
    }
}

