/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.CompressingServer;
import com.icesoft.faces.webapp.http.common.standard.PathDispatcherServer;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.encoding.Base64;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceDispatcher
implements Server {
    private static final Log log = LogFactory.getLog((Class)ResourceDispatcher.class);
    private static final ResourceLinker.Handler NOOPHandler = new ResourceLinker.Handler(){

        public void linkWith(ResourceLinker linker) {
        }
    };
    private PathDispatcherServer dispatcher = new PathDispatcherServer();
    private Server compressResource;
    private MimeTypeMatcher mimeTypeMatcher;
    private String prefix;
    private ArrayList registered = new ArrayList();
    private SessionDispatcher.Monitor monitor;

    public ResourceDispatcher(String prefix, MimeTypeMatcher mimeTypeMatcher, SessionDispatcher.Monitor monitor, Configuration configuration) {
        this.prefix = prefix;
        this.mimeTypeMatcher = mimeTypeMatcher;
        this.monitor = monitor;
        this.compressResource = new CompressingServer(this.dispatcher, mimeTypeMatcher, configuration);
    }

    public void service(Request request) throws Exception {
        try {
            this.compressResource.service(request);
        }
        catch (IOException e) {
            if (e.getClass().getName().endsWith("ClientAbortException")) {
                log.debug((Object)("Browser closed the connection prematurely for " + request.getURI()));
            }
            throw e;
        }
    }

    public URI registerResource(Resource resource) {
        return this.registerResource(resource, NOOPHandler);
    }

    public URI registerResource(Resource resource, ResourceLinker.Handler handler) {
        String dispatchFilename;
        String uriFilename;
        if (handler == null) {
            handler = NOOPHandler;
        }
        FileNameOption options = new FileNameOption();
        try {
            resource.withOptions(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = options.getFileName();
        if (filename == null || filename.trim().equals("")) {
            uriFilename = "";
            dispatchFilename = "";
        } else {
            filename = URLEncoder.encode(filename);
            dispatchFilename = filename.replaceAll("\\+", "\\\\+");
            uriFilename = filename;
        }
        String name = this.prefix + ResourceDispatcher.encode(resource) + "/";
        if (!this.registered.contains(name)) {
            this.registered.add(name);
            this.dispatcher.dispatchOn(".*" + name.replaceAll("\\/", "\\/") + dispatchFilename + "$", new ResourceServer(resource));
            if (handler != NOOPHandler) {
                handler.linkWith(new RelativeResourceLinker(name));
            }
        }
        return URI.create(name + uriFilename);
    }

    public void shutdown() {
        this.compressResource.shutdown();
        this.registered.clear();
    }

    private static String encode(Resource resource) {
        return Base64.encode(String.valueOf(resource.calculateDigest().hashCode()));
    }

    private class FileNameOption
    implements Resource.Options {
        private String fileName;

        private FileNameOption() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setAsAttachement() {
        }

        public void setExpiresBy(Date date) {
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setLastModified(Date date) {
        }

        public void setMimeType(String mimeType) {
        }
    }

    private class RelativeResourceLinker
    implements ResourceLinker {
        private final String name;

        public RelativeResourceLinker(String name) {
            this.name = name;
        }

        public void registerRelativeResource(String path, Resource relativeResource) {
            String pathExpression = (this.name + path).replaceAll("\\/", "\\/").replaceAll("\\.", "\\.");
            ResourceDispatcher.this.dispatcher.dispatchOn(".*" + pathExpression + "$", new ResourceServer(relativeResource));
        }
    }

    private class ResourceServer
    implements Server,
    ResponseHandler {
        private final Date lastModified = new Date();
        private final ResponseHandler notModified = new ResponseHandler(){

            public void respond(Response response) throws Exception {
                response.setStatus(304);
                response.setHeader("ETag", ResourceDispatcher.encode(ResourceServer.this.resource));
                response.setHeader("Date", new Date());
                response.setHeader("Last-Modified", ResourceServer.this.lastModified);
                response.setHeader("Expires", ResourceDispatcher.this.monitor.expiresBy());
            }
        };
        private final Resource resource;

        public ResourceServer(Resource resource) {
            this.resource = resource;
        }

        public void service(Request request) throws Exception {
            try {
                Date modifiedSince = request.getHeaderAsDate("If-Modified-Since");
                if (this.lastModified.getTime() > modifiedSince.getTime() + 1000L) {
                    request.respondWith(this);
                } else {
                    request.respondWith(this.notModified);
                }
            }
            catch (Exception e) {
                request.respondWith(this);
            }
        }

        public void respond(Response response) throws Exception {
            ResourceOptions options = new ResourceOptions();
            this.resource.withOptions(options);
            if (options.mimeType == null && options.fileName != null) {
                options.mimeType = ResourceDispatcher.this.mimeTypeMatcher.mimeTypeFor(options.fileName);
            }
            response.setHeader("ETag", ResourceDispatcher.encode(this.resource));
            response.setHeader("Cache-Control", "public");
            response.setHeader("Content-Type", options.mimeType);
            response.setHeader("Last-Modified", options.lastModified);
            response.setHeader("Expires", options.expiresBy);
            if (options.attachement) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + options.fileName + "\"");
            }
            response.writeBodyFrom(this.resource.open());
        }

        public void shutdown() {
        }

        private class ResourceOptions
        implements Resource.Options {
            private Date lastModified = new Date();
            private Date expiresBy = ResourceDispatcher.access$500(ResourceServer.access$400(ResourceServer.this)).expiresBy();
            private String mimeType;
            private String fileName;
            private boolean attachement;

            private ResourceOptions() {
            }

            public void setMimeType(String type) {
                this.mimeType = type;
            }

            public void setLastModified(Date date) {
                this.lastModified = date;
            }

            public void setFileName(String name) {
                this.fileName = name;
            }

            public void setExpiresBy(Date date) {
                this.expiresBy = date;
            }

            public void setAsAttachement() {
                this.attachement = true;
            }
        }
    }
}

