/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging.http;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.NotFoundHandler;
import com.icesoft.faces.webapp.http.common.standard.OKHandler;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.net.messaging.AbstractMessageServiceAdapter;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Container;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Or;
import com.icesoft.util.ServerUtility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpAdapter
extends AbstractMessageServiceAdapter
implements MessageServiceAdapter {
    private static final Log LOG = LogFactory.getLog((Class)HttpAdapter.class);
    private final Map messageHandlerMap = new HashMap();
    private final Map subscriberMap = new HashMap();
    private PseudoServlet httpMessagingDispatcher;
    private String localAddress;
    private int localPort;
    private boolean running = false;

    public HttpAdapter(ServletContext servletContext) {
        this(null, -1, servletContext);
    }

    public HttpAdapter(String localAddress, int localPort, final ServletContext servletContext) {
        super(servletContext);
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.httpMessagingDispatcher = new EnvironmentAdaptingServlet(new Server(){

            public void dispatch(Message message, String targetName) {
                if (HttpAdapter.this.subscriberMap.containsKey(targetName) && ((Expression)HttpAdapter.this.subscriberMap.get(targetName)).evaluate(message) && HttpAdapter.this.messageHandlerMap.containsKey(targetName)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Incoming message:\r\n\r\n" + message));
                    }
                    Set _messageHandlerSet = (Set)HttpAdapter.this.messageHandlerMap.get(targetName);
                    MessageHandler[] _messageHandlers = _messageHandlerSet.toArray(new MessageHandler[_messageHandlerSet.size()]);
                    for (int i = 0; i < _messageHandlers.length; ++i) {
                        MessageSelector _messageSelector = _messageHandlers[i].getMessageSelector();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("MessageHandler " + _messageHandlers[i] + ":\r\n" + _messageSelector));
                        }
                        if (_messageSelector != null && !_messageSelector.matches(message)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Match!");
                        }
                        _messageHandlers[i].handle(message);
                    }
                }
            }

            public void service(Request request) throws Exception {
                block10: {
                    if (LOG.isDebugEnabled()) {
                        StringBuffer _buffer = new StringBuffer();
                        _buffer.append(request.getMethod()).append(" ").append(request.getURI()).append("\r\n");
                        String[] _headerNames = request.getHeaderNames();
                        for (int i = 0; i < _headerNames.length; ++i) {
                            _buffer.append(_headerNames[i]).append(": ").append(request.getHeader(_headerNames[i])).append("\r\n");
                        }
                        LOG.debug((Object)("HTTP Request:\r\n\r\n" + _buffer));
                    }
                    if (request.getRemoteAddr().equals(ServerUtility.getLocalAddr(request, servletContext))) {
                        TextMessage _message;
                        block9: {
                            _message = new TextMessage(request.getParameter("message"));
                            HttpAdapter.headersToProperties(request, _message);
                            try {
                                request.respondWith(new OKHandler());
                            }
                            catch (Exception exception) {
                                if (!LOG.isErrorEnabled()) break block9;
                                LOG.error((Object)"An error occurred while trying to respond with: 200 OK", (Throwable)exception);
                            }
                        }
                        this.dispatch(_message, request.getHeader("X-Target-Name"));
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("404 Not Found (Request-URI: " + request.getURI() + ")"));
                        }
                        try {
                            request.respondWith(new NotFoundHandler(""));
                        }
                        catch (Exception exception) {
                            if (!LOG.isErrorEnabled()) break block10;
                            LOG.error((Object)"An error occurred while trying to respond with: 404 Not Found", (Throwable)exception);
                        }
                    }
                }
            }

            public void shutdown() {
            }
        }, new ServletContextConfiguration("com.icesoft.faces", servletContext), servletContext);
    }

    public void addMessageHandler(MessageHandler messageHandler, String targetName) {
        if (messageHandler != null && targetName != null && targetName.trim().length() != 0) {
            Set<MessageHandler> _messageHandlerSet;
            if (this.messageHandlerMap.containsKey(targetName)) {
                _messageHandlerSet = (Set)this.messageHandlerMap.get(targetName);
            } else {
                _messageHandlerSet = new HashSet();
                this.messageHandlerMap.put(targetName, _messageHandlerSet);
            }
            if (!_messageHandlerSet.contains(messageHandler)) {
                _messageHandlerSet.add(messageHandler);
            }
        }
    }

    public void close() throws MessageServiceException {
    }

    public PseudoServlet getHttpMessagingDispatcher() {
        return this.httpMessagingDispatcher;
    }

    /*
     * Loose catch block
     */
    public void publish(Message message, String targetName) throws MessageServiceException {
        block34: {
            if (message != null && targetName != null && targetName.trim().length() != 0 && this.running) {
                HttpURLConnection _connection = null;
                OutputStreamWriter _writer = null;
                InputStreamReader _reader = null;
                try {
                    block31: {
                        String _destinationServletContextPath = message.getStringProperty("destination_servletContextPath");
                        _connection = (HttpURLConnection)new URL("http", this.localAddress, this.localPort, (_destinationServletContextPath.startsWith("/") ? _destinationServletContextPath : "/" + _destinationServletContextPath) + "/block/message").openConnection();
                        _connection.setDoInput(true);
                        _connection.setDoOutput(true);
                        _connection.setRequestMethod("POST");
                        HttpAdapter.propertiesToHeaders(message, _connection);
                        _connection.setRequestProperty("X-Target-Name", targetName);
                        _writer = new OutputStreamWriter(_connection.getOutputStream());
                        _writer.write(HttpAdapter.encode("message") + '=' + HttpAdapter.encode(((TextMessage)message).getText()));
                        _writer.flush();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Outgoing message:\r\n\r\n" + message));
                        }
                        _reader = new InputStreamReader(_connection.getInputStream());
                        if (!LOG.isDebugEnabled()) break block31;
                        StringBuffer _buffer = new StringBuffer();
                        Iterator<Map.Entry<String, List<String>>> _headerFields = _connection.getHeaderFields().entrySet().iterator();
                        while (_headerFields.hasNext()) {
                            Map.Entry<String, List<String>> _headerField = _headerFields.next();
                            _buffer.append((Object)_headerField.getKey()).append(": ").append(_headerField.getValue()).append("\r\n");
                        }
                        LOG.debug((Object)("HTTP Response:\r\n\r\n" + _buffer));
                    }
                    Object var11_14 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (_connection != null && _connection.getContentLength() != 0 && _reader != null) {
                        try {
                            int _contentLength = _connection.getContentLength();
                            for (int i = 0; i < _contentLength; ++i) {
                                _reader.read();
                            }
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                    }
                    if (_writer != null) {
                        try {
                            _writer.close();
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                    }
                    if (_reader != null) {
                        try {
                            _reader.close();
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (_connection != null && _connection.getContentLength() != 0 && _reader != null) {
                    try {
                        int _contentLength = _connection.getContentLength();
                        for (int i = 0; i < _contentLength; ++i) {
                            _reader.read();
                        }
                    }
                    catch (IOException exception) {
                        // empty catch block
                    }
                }
                if (_writer != null) {
                    try {
                        _writer.close();
                    }
                    catch (IOException exception) {
                        // empty catch block
                    }
                }
                if (_reader != null) {
                    try {
                        _reader.close();
                    }
                    catch (IOException exception) {}
                }
                break block34;
                {
                    catch (UnsupportedEncodingException exception) {
                        throw new MessageServiceException(exception);
                    }
                    catch (IOException exception) {
                        if (_connection != null) {
                            try {
                                if (_connection.getResponseCode() == 503) {
                                    this.stop();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            try {
                                _reader = new InputStreamReader(_connection.getErrorStream());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw new MessageServiceException(exception);
                    }
                }
            }
        }
    }

    public void removeMessageHandler(MessageHandler messageHandler, String targetName) {
        Set _messageHandlerSet;
        if (messageHandler != null && targetName != null && targetName.trim().length() != 0 && this.messageHandlerMap.containsKey(targetName) && (_messageHandlerSet = (Set)this.messageHandlerMap.get(targetName)).contains(messageHandler)) {
            _messageHandlerSet.remove(messageHandler);
        }
    }

    public void setLocal(String localAddress, int localPort) {
        this.localAddress = localAddress;
        this.localPort = localPort;
    }

    public void shutdown() {
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public void subscribe(String targetName, MessageSelector messageSelector, boolean noLocal) throws MessageServiceException {
        if (targetName != null && targetName.trim().length() != 0) {
            Container _container = new Container(messageSelector.getExpression());
            if (this.subscriberMap.containsKey(targetName)) {
                this.subscriberMap.put(targetName, new Or((Expression)this.subscriberMap.get(targetName), _container));
            } else {
                this.subscriberMap.put(targetName, _container);
            }
        }
    }

    public void unsubscribe(String targetName) throws MessageServiceException {
        if (targetName != null && targetName.trim().length() != 0 && this.subscriberMap.containsKey(targetName)) {
            this.subscriberMap.remove(targetName);
        }
    }

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    private static void headersToProperties(Request request, Message message) {
        String _header = request.getHeader("X-Source-Servlet-Context-Path");
        if (_header != null) {
            message.setStringProperty("source_servletContextPath", _header);
        }
        if ((_header = request.getHeader("X-Source-Node-Address")) != null) {
            message.setStringProperty("source_nodeAddress", _header);
        }
        if ((_header = request.getHeader("X-Destination-Servlet-Context-Path")) != null) {
            message.setStringProperty("destination_servletContextPath", _header);
        }
        if ((_header = request.getHeader("X-Destination-Node-Address")) != null) {
            message.setStringProperty("destination_nodeAddress", _header);
        }
        if ((_header = request.getHeader("X-Message-Type")) != null) {
            message.setStringProperty("message_type", _header);
        }
        if ((_header = request.getHeader("X-Message-Lengths")) != null) {
            message.setStringProperty("message_lengths", _header);
        }
    }

    private static void propertiesToHeaders(Message message, HttpURLConnection connection) {
        if (message.propertyExists("source_servletContextPath")) {
            connection.setRequestProperty("X-Source-Servlet-Context-Path", message.getStringProperty("source_servletContextPath"));
        }
        if (message.propertyExists("source_nodeAddress")) {
            connection.setRequestProperty("X-Source-Node-Address", message.getStringProperty("source_nodeAddress"));
        }
        if (message.propertyExists("destination_servletContextPath")) {
            connection.setRequestProperty("X-Destination-Servlet-Context-Path", message.getStringProperty("destination_servletContextPath"));
        }
        if (message.propertyExists("destination_nodeAddress")) {
            connection.setRequestProperty("X-Destination-Node-Address", message.getStringProperty("destination_nodeAddress"));
        }
        if (message.propertyExists("message_type")) {
            connection.setRequestProperty("X-Message-Type", message.getStringProperty("message_type"));
        }
        if (message.propertyExists("message_lengths")) {
            connection.setRequestProperty("X-Message-Lengths", message.getStringProperty("message_lengths"));
        }
    }
}

