/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import org.icefaces.demo.auction.services.AuctionService;
import org.icefaces.demo.auction.services.Comparator.ItemBidsComparator;
import org.icefaces.demo.auction.services.Comparator.ItemExpiresComparator;
import org.icefaces.demo.auction.services.Comparator.ItemNameComparator;
import org.icefaces.demo.auction.services.Comparator.ItemPriceComparator;
import org.icefaces.demo.auction.services.beans.AuctionItem;

@ManagedBean(eager=true)
@ApplicationScoped
public class AuctionServiceImpl
implements AuctionService {
    private ArrayList<AuctionItem> auctionItems;

    @PostConstruct
    public void initializeData() {
        this.auctionItems = new ArrayList(4);
        this.auctionItems.add(new AuctionItem(1L, "ICEsoft Ice Breaker", "Used icebreaker with very few dents, comes with manual.", "Calgary, Alberta Canada", "ICEsoft Technologies, Inc.", new GregorianCalendar(), 5.0, 0, "icebreaker.jpg"));
        ((AuctionItem)this.auctionItems.get(0)).getExpiryDate().add(6, 2);
        ((AuctionItem)this.auctionItems.get(0)).getExpiryDate().add(11, 8);
        ((AuctionItem)this.auctionItems.get(0)).getExpiryDate().add(13, 60);
        this.auctionItems.add(new AuctionItem(2L, "ICEsoft Ice Skate", "A single sharpened ice skate, size 7.", "Calgary, Alberta Canada", "ICEsoft Technologies, Inc.", new GregorianCalendar(), 100.0, 0, "iceskate.jpg"));
        ((AuctionItem)this.auctionItems.get(1)).getExpiryDate().add(11, 8);
        ((AuctionItem)this.auctionItems.get(1)).getExpiryDate().add(13, 15);
        this.auctionItems.add(new AuctionItem(3L, "ICEsoft Ice Car", "Beautiful ice car with metal car filling.", "Calgary, Alberta Canada", "ICEsoft Technologies, Inc.", new GregorianCalendar(), 10.0, 0, "icecar.jpg"));
        ((AuctionItem)this.auctionItems.get(2)).getExpiryDate().add(6, 3);
        ((AuctionItem)this.auctionItems.get(2)).getExpiryDate().add(11, 5);
        ((AuctionItem)this.auctionItems.get(2)).getExpiryDate().add(13, 10);
        this.auctionItems.add(new AuctionItem(4L, "ICEsoft Ice Sailor", "Put him on the ice and watch him go!  Requires food and water.", "Calgary, Alberta Canada", "ICEsoft Technologies, Inc.", new GregorianCalendar(), 10000.0, 0, "icesailor.jpg"));
        ((AuctionItem)this.auctionItems.get(3)).getExpiryDate().add(6, 7);
        ((AuctionItem)this.auctionItems.get(3)).getExpiryDate().add(11, 2);
        ((AuctionItem)this.auctionItems.get(3)).getExpiryDate().add(13, 19);
    }

    public void resetAuctionItemCache() {
        this.initializeData();
    }

    public synchronized boolean bidOnAuctionItem(AuctionItem auctionItem, double bid) {
        for (AuctionItem item : this.auctionItems) {
            if (item.getId() != auctionItem.getId()) continue;
            if (item.getPrice() == auctionItem.getPrice()) {
                item.setPrice(bid);
                item.setBids(item.getBids() + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public List<AuctionItem> getAllAuctionItems(String sortColumn, boolean isAscending) {
        ItemNameComparator itemNameComparator;
        ArrayList<AuctionItem> currentAuctionItems = new ArrayList<AuctionItem>(this.auctionItems.size());
        for (AuctionItem auctionItem : this.auctionItems) {
            currentAuctionItems.add(new AuctionItem(auctionItem));
        }
        if ("nameColumn".equals(sortColumn)) {
            itemNameComparator = new ItemNameComparator(isAscending);
            Collections.sort(currentAuctionItems, itemNameComparator);
        } else if ("priceColumn".equals(sortColumn)) {
            itemNameComparator = new ItemPriceComparator(isAscending);
            Collections.sort(currentAuctionItems, itemNameComparator);
        } else if ("bidsColumn".equals(sortColumn)) {
            ItemBidsComparator itemBidComparator = new ItemBidsComparator(isAscending);
            Collections.sort(currentAuctionItems, itemBidComparator);
        } else if ("timeLeftColumn".equals(sortColumn)) {
            ItemExpiresComparator itemExpiresComparator = new ItemExpiresComparator(isAscending);
            Collections.sort(currentAuctionItems, itemExpiresComparator);
        }
        return currentAuctionItems;
    }
}

