/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.beans;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import org.icefaces.application.PushRenderer;
import org.icefaces.demo.auction.view.beans.AuctionItemBean;
import org.icefaces.demo.auction.view.controllers.AuctionController;
import org.icefaces.demo.auction.view.util.FacesUtils;

@ManagedBean
@ViewScoped
public class AuctionBean
implements Serializable {
    private static Logger logger = Logger.getLogger(AuctionBean.class.getName());
    public static final String AUCTION_RENDER_GROUP = "auctionRenderGroup";
    public static final String ITEM_NAME_COLUMN = "nameColumn";
    public static final String PRICE_COLUMN = "priceColumn";
    public static final String BIDS_COLUMN = "bidsColumn";
    public static final String TIME_LEFT_COLUMN = "timeLeftColumn";
    private String sortColumn = "timeLeftColumn";
    private boolean isDescending;
    private List<AuctionItemBean> auctionItems;

    @PostConstruct
    private void setInitialize() {
        AuctionController auctionController = (AuctionController)FacesUtils.getManagedBean((String)"auctionController");
        auctionController.refreshAuctionBean(this);
        PushRenderer.addCurrentSession((String)AUCTION_RENDER_GROUP);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("added current session to renderer 'auctionRenderGroup'");
        }
        PushRenderer.addCurrentSession((String)"auctionInterval");
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("added current session to renderer 'auctionInterval'");
        }
    }

    @PreDestroy
    private void destroy() {
        PushRenderer.removeCurrentView((String)AUCTION_RENDER_GROUP);
        PushRenderer.removeCurrentView((String)"auctionInterval");
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public boolean isAscending() {
        return this.isDescending;
    }

    public void setAscending(boolean descending) {
        this.isDescending = descending;
    }

    public List<AuctionItemBean> getAuctionItems() {
        return this.auctionItems;
    }

    public void setAuctionItems(List<AuctionItemBean> auctionItems) {
        this.auctionItems = auctionItems;
    }

    public String getItemNameColumn() {
        return ITEM_NAME_COLUMN;
    }

    public String getPriceColumn() {
        return PRICE_COLUMN;
    }

    public String getBidsColumn() {
        return BIDS_COLUMN;
    }

    public String getTimeLeftColumn() {
        return TIME_LEFT_COLUMN;
    }
}

