/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.event.ActionEvent;
import javax.faces.validator.ValidatorException;
import org.icefaces.application.PushRenderer;
import org.icefaces.demo.auction.services.AuctionService;
import org.icefaces.demo.auction.services.beans.AuctionItem;
import org.icefaces.demo.auction.view.beans.AuctionBean;
import org.icefaces.demo.auction.view.beans.AuctionItemBean;
import org.icefaces.demo.auction.view.util.FacesUtils;

@ManagedBean
@ApplicationScoped
public class AuctionController {
    private static Logger logger = Logger.getLogger(AuctionController.class.getName());

    public void refreshAuctionBean() {
        AuctionBean auctionBean = (AuctionBean)FacesUtils.getManagedBean((String)"auctionBean");
        this.refreshAuctionBean(auctionBean);
    }

    public void refreshAuctionBean(AuctionBean auctionBean) {
        AuctionService auctionService = (AuctionService)FacesUtils.getManagedBean((String)"auctionServiceImpl");
        List auctionItems = auctionService.getAllAuctionItems(auctionBean.getSortColumn(), auctionBean.isAscending());
        if (auctionItems == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Service layer contains no auction items. ");
            }
            auctionBean.setAuctionItems(null);
            return;
        }
        if (auctionBean.getAuctionItems() != null) {
            auctionBean.setAuctionItems(this.mergeAuctionData(auctionItems, auctionBean.getAuctionItems()));
        } else {
            ArrayList<AuctionItemBean> auctionItemBeans = new ArrayList<AuctionItemBean>(auctionItems.size());
            for (AuctionItem auction : auctionItems) {
                auctionItemBeans.add(new AuctionItemBean(auction));
            }
            auctionBean.setAuctionItems(auctionItemBeans);
        }
    }

    private List<AuctionItemBean> mergeAuctionData(List<AuctionItem> newAuctionItems, List<AuctionItemBean> currentAuctionItems) {
        ArrayList<AuctionItemBean> currentAuctionItemBeans = new ArrayList<AuctionItemBean>(newAuctionItems.size());
        for (AuctionItem auctionItem : newAuctionItems) {
            for (AuctionItemBean auctionItemBean : currentAuctionItems) {
                if (auctionItemBean.getAuctionItem().getId() != auctionItem.getId()) continue;
                double oldPrice = auctionItemBean.getAuctionItem().getPrice();
                double newPrice = auctionItem.getPrice();
                auctionItemBean.setAuctionItem(auctionItem);
                currentAuctionItemBeans.add(auctionItemBean);
                if (newPrice > oldPrice) {
                    auctionItemBean.setNewBidPrice(true);
                    continue;
                }
                auctionItemBean.setNewBidPrice(false);
            }
        }
        return currentAuctionItemBeans;
    }

    public void placeBid(ActionEvent event) {
        AuctionItemBean auctionItemBean;
        AuctionService auctionService = (AuctionService)FacesUtils.getManagedBean((String)"auctionServiceImpl");
        boolean success = auctionService.bidOnAuctionItem((auctionItemBean = (AuctionItemBean)FacesUtils.getRequestMapValue((String)"auctionItem")).getAuctionItem(), auctionItemBean.getBid());
        if (!success) {
            PropertyResourceBundle msgs = (PropertyResourceBundle)FacesUtils.getManagedBean((String)"msgs");
            FacesMessage message = new FacesMessage();
            message.setDetail(msgs.getString("auction.bid.rebid.error"));
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
        AuctionBean auctionBean = (AuctionBean)FacesUtils.getManagedBean((String)"auctionBean");
        this.refreshAuctionBean(auctionBean);
        PushRenderer.render((String)"auctionRenderGroup");
    }

    public void toggleBidInput(ActionEvent event) {
        AuctionItemBean auctionItemBean;
        auctionItemBean.setShowBidInput(!(auctionItemBean = (AuctionItemBean)FacesUtils.getRequestMapValue((String)"auctionItem")).isShowBidInput());
        AuctionBean auctionBean = (AuctionBean)FacesUtils.getManagedBean((String)"auctionBean");
        List auctionItems = auctionBean.getAuctionItems();
        for (AuctionItemBean auctionItem : auctionItems) {
            if (auctionItem.equals(auctionItemBean)) continue;
            auctionItem.setShowBidInput(false);
        }
        auctionItemBean.setBid(auctionItemBean.getAuctionItem().getPrice() + 5.0);
    }

    public void toggleExtendedDescription(ActionEvent event) {
        AuctionItemBean auctionItemBean;
        auctionItemBean.setShowExtendedDescription(!(auctionItemBean = (AuctionItemBean)FacesUtils.getRequestMapValue((String)"auctionItem")).isShowExtendedDescription());
    }
}

