/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.validators;

import java.util.PropertyResourceBundle;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.icefaces.demo.auction.view.beans.AuctionItemBean;
import org.icefaces.demo.auction.view.util.FacesUtils;

@FacesValidator(value="auctionItemBidValidator")
public class BidValidator
implements Validator {
    private static final Logger LOGGER = Logger.getLogger(BidValidator.class.getName());
    public static final int MAX_BID_INCREASE = 10000;
    public static final long MAX_BID = 1000000L;

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        double newBid;
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        AuctionItemBean auctionMonitorItemBean = (AuctionItemBean)externalContext.getRequestMap().get("auctionItem");
        double originalBid = auctionMonitorItemBean.getAuctionItem().getPrice();
        double d = newBid = value != null ? (Double)value : 0.0;
        if (auctionMonitorItemBean.isExpired()) {
            FacesMessage message = new FacesMessage();
            message.setDetail("Item has expired, bids are closed");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
        PropertyResourceBundle msgs = (PropertyResourceBundle)FacesUtils.getManagedBean((String)"msgs");
        if (newBid <= originalBid) {
            FacesMessage message = new FacesMessage();
            message.setDetail(msgs.getString("auction.validator.bidLow"));
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
        if (newBid > 1000000.0 || newBid - originalBid > 10000.0) {
            FacesMessage message = new FacesMessage();
            message.setDetail(msgs.getString("auction.validator.bidHigh"));
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
    }
}

