/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.beans;

import java.io.Serializable;
import java.util.Calendar;
import org.icefaces.demo.auction.services.beans.AuctionItem;

public class AuctionItemBean
implements Serializable {
    public static final int TIME_LEFT_5_SEC = 0;
    public static final int TIME_LEFT_10_SEC = 1;
    public static final int TIME_LEFT_15_SEC = 2;
    public static final int TIME_LEFT_30_SEC = 3;
    public static final int TIME_LEFT_45_SEC = 4;
    public static final int TIME_LEFT_HOURS = 5;
    public static final int TIME_LEFT_DAYS = 6;
    public static final int TIME_LEFT_EXPIRED = 7;
    public static final int TIME_LEFT_NA = 8;
    public static final int DAY_COMPONENT = 0;
    public static final int HOUR_COMPONENT = 1;
    public static final int MINUTE_COMPONENT = 2;
    public static final int SECOND_COMPONENT = 3;
    private static final int TIME_DAYS = 86400000;
    private static final int TIME_HOURS = 3600000;
    private static final int TIME_MINUTES = 60000;
    private AuctionItem auctionItem;
    private double bid;
    private boolean showBidInput;
    private boolean showExtendedDescription;
    private boolean newBidPrice;

    public AuctionItemBean(AuctionItem auctionItem) {
        this.auctionItem = auctionItem;
    }

    public AuctionItem getAuctionItem() {
        return this.auctionItem;
    }

    public void setAuctionItem(AuctionItem auctionItem) {
        this.auctionItem = auctionItem;
    }

    public boolean isShowBidInput() {
        return this.showBidInput;
    }

    public void setShowBidInput(boolean showBidInput) {
        this.showBidInput = showBidInput;
    }

    public boolean isShowExtendedDescription() {
        return this.showExtendedDescription;
    }

    public void setShowExtendedDescription(boolean showExtendedDescription) {
        this.showExtendedDescription = showExtendedDescription;
    }

    public double getBid() {
        return this.bid;
    }

    public void setBid(double bid) {
        this.bid = bid;
    }

    public boolean isNewBidPrice() {
        return this.newBidPrice;
    }

    public void setNewBidPrice(boolean newBidPrice) {
        this.newBidPrice = newBidPrice;
    }

    public long[] getTimeLeftBrokenDown() {
        if (this.auctionItem.getExpiryDate() != null) {
            long left = this.auctionItem.getExpiryDate().getTime().getTime() - Calendar.getInstance().getTime().getTime();
            long days = left / 86400000L;
            long hours = (left -= days * 86400000L) / 3600000L;
            long minutes = (left -= hours * 3600000L) / 60000L;
            long seconds = (left -= minutes * 60000L) / 1000L;
            return new long[]{days, hours, minutes, seconds};
        }
        return null;
    }

    public boolean isExpired(long[] countDownTime) {
        return countDownTime[0] <= 0L && countDownTime[1] <= 0L && countDownTime[2] <= 0L && countDownTime[3] <= 0L;
    }

    public boolean isExpired() {
        return this.isExpired(this.getTimeLeftBrokenDown());
    }

    public String getTimeLeftType() {
        if (this.auctionItem.getExpiryDate() != null) {
            long[] countDownTime = this.getTimeLeftBrokenDown();
            if (countDownTime[0] > 0L) {
                return String.valueOf(6);
            }
            if (countDownTime[1] > 0L) {
                return String.valueOf(5);
            }
            if (countDownTime[3] >= 0L) {
                long seconds = countDownTime[3];
                if (seconds < 60L && seconds >= 45L) {
                    return String.valueOf(4);
                }
                if (seconds < 45L && seconds >= 30L) {
                    return String.valueOf(3);
                }
                if (seconds < 30L && seconds >= 15L) {
                    return String.valueOf(2);
                }
                if (seconds < 15L && seconds >= 10L) {
                    return String.valueOf(2);
                }
                if (seconds < 10L && seconds >= 5L) {
                    return String.valueOf(1);
                }
                if (seconds < 5L && seconds > 0L) {
                    return String.valueOf(0);
                }
                return String.valueOf(7);
            }
            return String.valueOf(7);
        }
        return String.valueOf(8);
    }
}

