/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.controllers;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import org.icefaces.application.PortableRenderer;
import org.icefaces.application.PushRenderer;
import org.icefaces.demo.auction.view.util.FacesUtils;

@ManagedBean(eager=true)
@ApplicationScoped
public class IntervalPushRenderer {
    private static Logger log = Logger.getLogger(IntervalPushRenderer.class.getName());
    public static final String INTERVAL_RENDER_GROUP = "auctionInterval";
    private int pollingInterval = 1000;
    private Timer intervalTimer;
    private TimerTask renderTask;

    public IntervalPushRenderer() {
        String interval = FacesUtils.getFacesParameter((String)"org.icefaces.sample.auction.interval");
        if (interval != null) {
            try {
                this.pollingInterval = Integer.parseInt(interval);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Error applying org.icefaces.demo.auction.interval, must be valid integer.", e);
            }
        }
        PortableRenderer renderer = PushRenderer.getPortableRenderer();
        this.renderTask = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void initializeIntervalRender() {
        if (null != this.intervalTimer) {
            this.intervalTimer.cancel();
        }
        this.intervalTimer = new Timer(true);
        this.intervalTimer.schedule(this.renderTask, 0L, (long)this.pollingInterval);
    }

    public void cleanup() {
        if (null != this.intervalTimer) {
            this.intervalTimer.purge();
            this.intervalTimer.cancel();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("cleaning up " + this.intervalTimer);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ Timer access$100(IntervalPushRenderer x0) {
        return x0.intervalTimer;
    }
}

