/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.demo.auction.view.converters;

import java.util.PropertyResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import org.icefaces.demo.auction.view.beans.AuctionItemBean;
import org.icefaces.demo.auction.view.util.FacesUtils;

@FacesConverter(value="auctionItemDateConverter")
public class ExpiryDateConverter
implements Converter {
    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object o) {
        if (o instanceof AuctionItemBean) {
            AuctionItemBean auctionItemBean = (AuctionItemBean)o;
            long[] countDownTime = auctionItemBean.getTimeLeftBrokenDown();
            if (auctionItemBean.isExpired(countDownTime)) {
                PropertyResourceBundle msgs = (PropertyResourceBundle)FacesUtils.getManagedBean((String)"msgs");
                return msgs.getString("auction.converter.timeLeft.expired");
            }
            StringBuffer buf = new StringBuffer();
            if (0L != countDownTime[0]) {
                buf.append(String.valueOf(countDownTime[0]));
                buf.append("d ");
            }
            if (0L != countDownTime[1]) {
                buf.append(String.valueOf(countDownTime[1]));
                buf.append(":");
                if (countDownTime[2] < 10L) {
                    buf.append("0");
                }
            }
            buf.append(String.valueOf(countDownTime[2]));
            buf.append(":");
            if (countDownTime[3] < 10L) {
                buf.append("0");
            }
            buf.append(Long.toString(countDownTime[3]));
            return buf.toString();
        }
        PropertyResourceBundle msgs = (PropertyResourceBundle)FacesUtils.getManagedBean((String)"msgs");
        return msgs.getString("auction.converter.timeLeft.na");
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String s) {
        return null;
    }
}

