/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.sample.portlet.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import org.icefaces.application.PortableRenderer;
import org.icefaces.application.PushRenderer;
import org.icefaces.sample.portlet.chat.Message;
import org.icefaces.sample.portlet.chat.Participant;
import org.icefaces.sample.portlet.chat.resources.ResourceUtil;

@ManagedBean(eager=true)
@ApplicationScoped
public class ChatRoom {
    private static Logger log = Logger.getLogger(Participant.class.getName());
    public static final String ROOM_RENDERER_NAME = "all";
    private Map participants = Collections.synchronizedMap(new HashMap());
    private List messages = Collections.synchronizedList(new ArrayList());
    private PortableRenderer portableRenderer = PushRenderer.getPortableRenderer();

    public void addParticipant(Participant participant) {
        if (this.hasParticipant(participant)) {
            return;
        }
        this.participants.put(participant.getHandle(), participant);
        PushRenderer.addCurrentSession((String)ROOM_RENDERER_NAME);
        String localizedMessage = ResourceUtil.getLocalizedMessage((String)"joined", (String)participant.getHandle());
        this.addMessage(participant, localizedMessage);
    }

    public void removeParticipant(Participant participant) {
        if (!this.hasParticipant(participant)) {
            return;
        }
        this.participants.remove(participant.getHandle());
        String localizedMessage = ResourceUtil.getLocalizedMessage((String)"left", (String)participant.getHandle());
        this.addMessage(participant, localizedMessage);
    }

    public String[] getHandles() {
        return this.participants.keySet().toArray(new String[this.participants.size()]);
    }

    public int getNumberOfParticipants() {
        return this.participants.size();
    }

    public List getMessages() {
        return this.messages;
    }

    public int getNumberOfMessages() {
        return this.messages.size();
    }

    protected void addMessage(Message message) {
        this.messages.add(0, message.getFormattedMessage());
    }

    public void addMessage(Participant participant, String message) {
        if (participant != null && participant.getHandle() != null) {
            this.addMessage(new Message(participant, message));
            PushRenderer.render((String)ROOM_RENDERER_NAME);
            this.portableRenderer.render(ROOM_RENDERER_NAME);
        }
    }

    public boolean hasParticipant(Participant participant) {
        return this.participants.containsKey(participant.getHandle());
    }

    public List getMessages(int start, int number) {
        int totalMessages = this.messages.size();
        if (start > totalMessages) {
            start = 0;
        }
        if (start + number > totalMessages) {
            number = totalMessages - start;
        }
        ArrayList subList = new ArrayList();
        for (int index = start; index < start + number; ++index) {
            subList.add(this.messages.get(index));
        }
        return subList;
    }
}

