/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.sample.portlet.chat;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.icefaces.application.PushRenderer;
import org.icefaces.sample.portlet.chat.ChatRoom;
import org.icefaces.sample.portlet.chat.resources.ResourceUtil;

@ManagedBean
@SessionScoped
public class Participant
implements Serializable {
    private static Logger log = Logger.getLogger(Participant.class.getName());
    @ManagedProperty(value="#{chatRoom}")
    private transient ChatRoom chatRoom;
    private String handle;
    private String message;
    private int firstMessageIndex = 0;
    private int numOfDisplayedMessages = 5;

    @PostConstruct
    public void init() {
        PushRenderer.addCurrentSession((String)"all");
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle.trim();
    }

    public ChatRoom getChatRoom() {
        if (this.chatRoom == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.chatRoom = (ChatRoom)context.getApplication().evaluateExpressionGet(context, "#{chatRoom}", Object.class);
        }
        return this.chatRoom;
    }

    public void setChatRoom(ChatRoom chatRoom) {
        this.chatRoom = chatRoom;
    }

    public String getMessage() {
        return "";
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void login(ActionEvent event) {
        if (this.handle != null && this.handle.trim().length() > 0) {
            ChatRoom cr = this.getChatRoom();
            if (!cr.hasParticipant(this)) {
                cr.addParticipant(this);
            } else {
                ResourceUtil.addLocalizedMessage((String)"alreadyRegistered", (String)this.handle);
                this.handle = null;
            }
        } else {
            ResourceUtil.addLocalizedMessage((String)"badHandle");
        }
    }

    public void sendMessage(ActionEvent event) {
        ChatRoom cr = this.getChatRoom();
        if (!cr.hasParticipant(this) || this.message == null || this.message.trim().length() < 1) {
            return;
        }
        cr.addMessage(this, this.message);
    }

    public void logout(ActionEvent event) {
        this.logout();
    }

    @PreDestroy
    public void logout() {
        try {
            ChatRoom cr = this.getChatRoom();
            if (cr != null) {
                cr.removeParticipant(this);
            }
            PushRenderer.removeCurrentSession((String)"all");
        }
        catch (Exception e) {
            log.log(Level.FINEST, "error logging out", e);
        }
        this.handle = null;
    }

    public boolean isRegistered() {
        return this.getChatRoom().hasParticipant(this);
    }

    public void setRegistered(boolean registered) {
    }

    public String toString() {
        return super.toString() + " [" + this.handle + "]";
    }

    public int getFirstMessageIndex() {
        return this.firstMessageIndex;
    }

    public void setFirstMessageIndex(int firstMessageIndex) {
    }

    public int getNumOfDisplayedMessages() {
        return this.numOfDisplayedMessages;
    }

    public void setNumOfDisplayedMessages(int numOfDisplayedMessages) {
    }

    public boolean isOlder() {
        return this.firstMessageIndex + this.numOfDisplayedMessages < this.getChatRoom().getNumberOfMessages();
    }

    public void olderMessages(ActionEvent event) {
        ++this.firstMessageIndex;
        if (this.firstMessageIndex > this.chatRoom.getNumberOfMessages() - 1) {
            this.firstMessageIndex = this.chatRoom.getNumberOfMessages() - 1;
        }
    }

    public boolean isNewer() {
        return this.firstMessageIndex > 0;
    }

    public void newerMessages(ActionEvent event) {
        --this.firstMessageIndex;
        if (this.firstMessageIndex < 0) {
            this.firstMessageIndex = 0;
        }
    }

    public List getMessages() {
        return this.getChatRoom().getMessages(this.firstMessageIndex, this.numOfDisplayedMessages);
    }
}

