/*
 * Copyright 2004-2014 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.icefaces.samples.showcase.view.menu.data;

import java.util.ArrayList;
import java.util.List;

import org.icefaces.samples.showcase.util.FacesUtils;
import org.icefaces.samples.showcase.view.menu.CategoryGroup;
import org.icefaces.samples.showcase.view.menu.ComponentGroup;
import org.icefaces.samples.showcase.view.menu.Demo;
import org.icefaces.samples.showcase.view.menu.DemoResource;
import org.icefaces.samples.showcase.view.menu.DemoSource;

/**
To add a new demo to the Component Showcase the main class you will work with is org.icefaces.samples.showcase.view.menu.data.CentralDataList
Inside here you will see the structure for our menu navigation. A hierarchy order of CategoryGroup -> ComponentGroup -> Demo is used
For example Input -> ace:textEntry -> Label Position

1. Create your XHTML file for the demo under src/main/webapp/resources/examples/ace/COMPONENT/demoName.xhtml with COMPONENT being something like "textEntry"
This XHTML file is a template-client and uses template="/resources/templates/content-template.xhtml" and a <ui:define name="example"> for the main content

2. If you require a backing bean create any Java classes under src/main/java/org/icefaces/samples/showcase/example/ace/COMPONENT/BeanName.java
These are standard beans, normally Window or View scoped

3. Add your new demo to the CentralDataList.java class, located at src/main/java/org/icefaces/samples/showcase/view/menu/data. You can follow the existing structure as a guide. You can see how ICE Core need a bit more 
setup compared to ACE, various examples with custom DemoResource and DemoSource lists, and a few full page refresh examples
There are many flexible constructors for each of the objects, so you can customize the demo as much as you need.
If you are adding an ace demo with only one bean a simple example to follow would be the ajax component.
All URL bookmarkability and search box integration will be handled automatically for a properly structured demo.
Note that we try to internationalize as many strings as we can in messages.properties. The convenience method msgs(String key) in CentralDataList can be used to easily retrieve strings.
The classes involved...

CategoryGroup: The main menu tier, has a "name" and a list of ComponentGroup objects

ComponentGroup: A set of demos for a specific component (like ace:textEntry). Contains:
name
keywords (optional, comma separated list of phrases we want to search by)
fullPageRefresh (false by default, set to true to ensure your demo page will refresh the entire browser if navigated to, such as for ace:gMap)
list of DemoResource objects (basically links to Wiki and TLD. A convenience constructor handles a lot of this creation)
list of Demo objects

Demo: An individual demo for a component, such as Overview or Label Position for ace:textEntry
name (should be unique within the component group)
description (make sure to internationalize this one)
list of DemoSource objects (used by the source code viewer on the page to show XHTML or Java source. The first XHTML page declared will be used as the demo content as well)
 */
public class CentralDataList {
	public static List<CategoryGroup> generate() {
		List<CategoryGroup> toReturn = new ArrayList<CategoryGroup>();
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.aceSuiteOverview.title"),
				new ComponentGroup(msgs("menu.ace.aceSuiteOverview.title"),
								new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "ACE Components Wiki", "ACE+Components"),
													 new DemoResource(DemoResource.Type.WIKI, "ICECORE Components Wiki", "ICECORE+Components"),
													 new DemoResource(DemoResource.Type.TLD, "ACE Components TLD", "tld-summary.html"),
													 new DemoResource(DemoResource.Type.TLD, "ICECORE Components TLD", DemoResource.CORE_TLD_PATH_BASE + "tld-summary.html", true)},
					 new Demo(msgs("overview"), null,
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "aceSuiteOverview.xhtml", "aceSuiteOverview") }))));
		
		toReturn.add(new CategoryGroup(msgs("menu.core.group.title"),
				new ComponentGroup("icecore:defaultAction",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "defaultAction"),
						  new DemoResource(DemoResource.Type.TLD, "icecore:defaultAction", DemoResource.CORE_TLD_PATH_BASE + "defaultAction.html", true) },
					new Demo(msgs("overview"), msgs("example.core.defaultActionBean.description"),
							new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "default-action.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
											   new DemoSource(DemoSource.Type.JAVA, "DefaultActionBean.java", DemoSource.CORE_JAVA_PATH_BASE + "defaultAction/", true) })),
				new ComponentGroup("icecore:focusManager",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "focusManager"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:focusManager", DemoResource.CORE_TLD_PATH_BASE + "focusManager.html", true) },
					new Demo(msgs("overview"), msgs("example.core.focusManagerBean.description"),
							new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "focus-manager.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
											   new DemoSource(DemoSource.Type.JAVA, "FocusManagerBean.java", DemoSource.CORE_JAVA_PATH_BASE + "focusManager/", true) })),
				new ComponentGroup("icecore:idleMonitor",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "idleMonitor"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:idleMonitor", DemoResource.CORE_TLD_PATH_BASE + "idleMonitor.html", true) },
						new Demo(msgs("overview"), msgs("example.core.idleMonitorBean.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "idle-monitor.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "IdleMonitorBean.java", DemoSource.CORE_JAVA_PATH_BASE + "idleMonitor/", true) })),
				new ComponentGroup("icecore:jsEventListener",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "jsEventListener"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:jsEventListener", DemoResource.CORE_TLD_PATH_BASE + "jsEventListener.html", true) },
						new Demo(msgs("overview"), msgs("example.core.jsEventListenerBean.description"), msgs("overview") + ", javascript callback",
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "js-event-listener.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "JsEventListenerBean.java", DemoSource.CORE_JAVA_PATH_BASE + "jsEventListener/", true) })),
				new ComponentGroup("icecore:loadBundle",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "loadBundle"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:loadBundle", DemoResource.CORE_TLD_PATH_BASE + "loadBundle.html", true) },
						new Demo(msgs("overview"), msgs("example.core.loadBundleBean.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "load-bundle.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "LoadBundleBean.java", DemoSource.CORE_JAVA_PATH_BASE + "loadBundle/", true),
												   new DemoSource(DemoSource.Type.JAVA, "LoadBundleViewScopeBean.java", DemoSource.CORE_JAVA_PATH_BASE + "loadBundle/", true)})),
				new ComponentGroup("icecore:navigationNotifier",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "navigationNotifier"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:navigationNotifier", DemoResource.CORE_TLD_PATH_BASE + "navigationNotifier.html", true) },
						new Demo(msgs("overview"), msgs("example.core.navigationNotifierBean.description"), msgs("overview") + ", history manager",
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "navigation-notifier.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
										           new DemoSource(DemoSource.Type.XHTML, "navigation-notifier-next.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "NavigationNotifierBean.java", DemoSource.CORE_JAVA_PATH_BASE + "navigationNotifier/", true),
												   new DemoSource(DemoSource.Type.JAVA, "NavigationNotifierViewScopeBean.java", DemoSource.CORE_JAVA_PATH_BASE + "navigationNotifier/", true)})),
				new ComponentGroup("icecore:push",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "push"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:push", DemoResource.CORE_TLD_PATH_BASE + "push.html", true) },
						new Demo(msgs("overview"), msgs("example.core.pushBean.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "push.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "PushBean.java", DemoSource.CORE_JAVA_PATH_BASE + "push/", true),
												   new DemoSource(DemoSource.Type.JAVA, "PushWindowScopeBean.java", DemoSource.CORE_JAVA_PATH_BASE + "push/", true)})),
				new ComponentGroup("icecore:redirect",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "redirect"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:redirect", DemoResource.CORE_TLD_PATH_BASE + "redirect.html", true) },
						new Demo(msgs("overview"), msgs("example.core.redirectBean.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "redirect.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "RedirectBean.java", DemoSource.CORE_JAVA_PATH_BASE + "redirect/", true),
												   new DemoSource(DemoSource.Type.JAVA, "RedirectViewScopeBean.java", DemoSource.CORE_JAVA_PATH_BASE + "redirect/", true)})),
				new ComponentGroup("icecore:refresh",
						new DemoResource[] { new DemoResource(DemoResource.Type.WIKI, "refresh"),
						 new DemoResource(DemoResource.Type.TLD, "icecore:refresh", DemoResource.CORE_TLD_PATH_BASE + "refresh.html", true) },
						new Demo(msgs("overview"), msgs("example.core.refreshBean.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "refresh.xhtml", DemoSource.CORE_XHTML_PATH_BASE, true),
												   new DemoSource(DemoSource.Type.JAVA, "RefreshBean.java", DemoSource.CORE_JAVA_PATH_BASE + "refresh/", true),
												   new DemoSource(DemoSource.Type.JAVA, "RefreshViewScopeBean.java", DemoSource.CORE_JAVA_PATH_BASE + "refresh/", true)}))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.ajax.title"),
				new ComponentGroup("ace:ajax", "Ajax", "ajax.html", "singleSubmit, partialSubmit",
					new Demo(msgs("overview"), msgs("example.ace.ajax.description"),
							 "ajax", "ajax.xhtml", "AjaxBean.java"),
					 new Demo(msgs("menu.ace.ajax.subMenu.advanced"), msgs("example.ace.ajax.advanced.description"),
							 "ajax", "ajaxAdvanced.xhtml", "AjaxAdvancedBean.java"),
					 new Demo(msgs("menu.ace.ajax.subMenu.callbacks"), msgs("example.ace.ajax.callbacks.description"),
							 "ajax", "ajaxCallbacks.xhtml", "AjaxCallbacksBean.java")),
				 new ComponentGroup("ace:submitMonitor", "SubmitMonitor", "submitMonitor.html",
					new Demo(msgs("overview"), msgs("example.ace.submitMonitor.description"),
							 "submitMonitor", "submitMonitor.xhtml", "SubmitMonitorBean.java"),
					 new Demo(msgs("menu.ace.submitMonitor.subMenu.configuration"), msgs("example.ace.submitMonitor.configuration.description"),
							 "submitMonitor", "submitMonitorConfiguration.xhtml", "SubmitMonitorConfiguration.java"),
					 new Demo(msgs("menu.ace.submitMonitor.subMenu.style"), msgs("example.ace.submitMonitor.style.description"),
							 "submitMonitor", "submitMonitorStyle.xhtml", "SubmitMonitorStyle.java"),
					 new Demo(msgs("menu.ace.submitMonitor.subMenu.nested"), msgs("example.ace.submitMonitor.nested.description"),
							 "submitMonitor", "submitMonitorNested.xhtml", "SubmitMonitorNested.java"),
					 new Demo(msgs("menu.ace.submitMonitor.subMenu.facet"), msgs("example.ace.submitMonitor.facet.description"),
							 "submitMonitor", "submitMonitorFacet.xhtml", "SubmitMonitorFacet.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.input.title"),
				new ComponentGroup("ace:autoCompleteEntry", "AutoCompleteEntry", "autoCompleteEntry.html", "selectInputText",
					new Demo(msgs("overview"), msgs("example.ace.autocompleteentry.description"),
							 "autocompleteentry", "autoCompleteEntry.xhtml", "AutoCompleteEntryBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.select"), msgs("example.ace.autocompleteentry.select.description"),
							 "autocompleteentry", "autoCompleteEntrySelect.xhtml", "AutoCompleteEntrySelectBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.facet"), msgs("example.ace.autocompleteentry.facet.description"),
							 "autocompleteentry", "autoCompleteEntryFacet.xhtml", "AutoCompleteEntryFacetBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.match"), msgs("example.ace.autocompleteentry.match.description"),
							 "autocompleteentry", "autoCompleteEntryMatch.xhtml", "AutoCompleteEntryMatchBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.rows"), msgs("example.ace.autocompleteentry.rows.description"),
							 "autocompleteentry", "autoCompleteEntryRows.xhtml", "AutoCompleteEntryRowsBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.lazy"), msgs("example.ace.autocompleteentry.lazy.description"),
							 "autocompleteentry", "autoCompleteEntryLazy.xhtml", "AutoCompleteEntryLazyBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.label"), msgs("example.ace.autocompleteentry.label.description"),
							 "autocompleteentry", "autoCompleteEntryLabel.xhtml", "AutoCompleteEntryLabelBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.indicator"), msgs("example.ace.autocompleteentry.indicator.description"),
							 "autocompleteentry", "autoCompleteEntryIndicator.xhtml", "AutoCompleteEntryIndicatorBean.java"),
					 new Demo(msgs("menu.ace.autocompleteentry.subMenu.reqStyle"), msgs("example.ace.autocompleteentry.reqStyle.description"),
							 "autocompleteentry", "autoCompleteEntryReqStyle.xhtml", "AutoCompleteEntryReqStyleBean.java")),
				new ComponentGroup("ace:dateTimeEntry", "DateTimeEntry", "dateTimeEntry.html", "calendar, datepicker",
					new Demo(msgs("overview"), msgs("example.ace.dateentry.description"),
							 "date", "dateentry.xhtml", "DateEntryBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.popup"), msgs("example.ace.dateentry.popup.description"),
							 "date", "datepopup.xhtml", "DatePopupBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.timeentry"), msgs("example.ace.dateentry.timeentry.description"),
							 "date", "datetimeentry.xhtml", "DateTimeBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.ajax"), msgs("example.ace.dateentry.ajax.description"),
							 "date", "dateajax.xhtml", "DateAjaxBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.pages"), msgs("example.ace.dateentry.pages.description"),
							 "date", "datepages.xhtml", "DatePagesBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.minmax"), msgs("example.ace.dateentry.minmax.description"),
							 "date", "dateminmax.xhtml", "DateMinMaxBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.navigator"), msgs("example.ace.dateentry.navigator.description"),
							 "date", "datenavigator.xhtml", "DateNavigatorBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.label"), msgs("example.ace.dateentry.label.description"),
							 "date", "datelabel.xhtml", "DateLabelBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.indicator"), msgs("example.ace.dateentry.indicator.description"),
							 "date", "dateindicator.xhtml", "DateIndicatorBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.reqStyle"), msgs("example.ace.dateentry.reqStyle.description"),
							 "date", "datereqstyle.xhtml", "DateReqStyleBean.java"),
					new Demo(msgs("menu.ace.dateentry.subMenu.locale"), msgs("example.ace.dateentry.locale.description"),
							 "date", "datelocale.xhtml", "DateLocaleBean.java")),
				new ComponentGroup("ace:maskedEntry", "MaskedEntry", "maskedEntry.html", "inputMask",
					new Demo(msgs("overview"), msgs("example.ace.maskedEntry.description"),
							 "maskedEntry", "maskedEntry.xhtml", "MaskedEntryBean.java"),
					new Demo(msgs("menu.ace.maskedEntry.subMenu.label"), msgs("example.ace.maskedLabel.description"),
							 "maskedEntry", "maskedLabel.xhtml", "MaskedLabelBean.java"),
					new Demo(msgs("menu.ace.maskedEntry.subMenu.indicator"), msgs("example.ace.maskedIndicator.description"),
							 "maskedEntry", "maskedIndicator.xhtml", "MaskedIndicatorBean.java"),
					new Demo(msgs("menu.ace.maskedEntry.subMenu.reqStyle"), msgs("example.ace.maskedReqStyle.description"),
							 "maskedEntry", "maskedReqStyle.xhtml", "MaskedReqStyleBean.java")),
				new ComponentGroup("ace:richTextEntry", "RichTextEntry", "richTextEntry.html",
					new Demo(msgs("overview"), msgs("example.ace.richtextentry.description"),
							 "richtextentry", "richTextEntryOverview.xhtml", "RichTextEntryBean.java")),
				new ComponentGroup("ace:sliderEntry", "SliderEntry", "sliderEntry.html",
					new Demo(msgs("overview"), msgs("example.ace.slider.description"),
							 "slider", "slider.xhtml", "SliderBean.java"),
					new Demo(msgs("menu.ace.slider.subMenu.asyncinput"), msgs("example.ace.slider.asyncinput.description"),
							 "slider", "slider-async-input.xhtml", "SliderAsyncInputBean.java"),
					new Demo(msgs("menu.ace.slider.subMenu.listener"), msgs("example.ace.slider.listener.description"),
							 "slider", "sliderListener.xhtml", "SliderListener.java"),
					new Demo(msgs("menu.ace.slider.subMenu.submitionExample"), msgs("example.ace.slider.submition.description"),
							 "slider", "sliderSubmition.xhtml", "SliderSubmitionExample.java"),
					new Demo(msgs("menu.ace.slider.subMenu.label"), msgs("example.ace.slider.label.description"),
							 "slider", "sliderEntryLabel.xhtml", "SliderEntryLabelBean.java")),
				new ComponentGroup("ace:textAreaEntry", "TextAreaEntry", "textAreaEntry.html", "inputTextArea",
					new Demo(msgs("overview"), msgs("example.ace.textAreaEntry.description"),
							 "textAreaEntry", "textAreaEntry.xhtml", "TextAreaEntryBean.java"),
					new Demo(msgs("menu.ace.textAreaEntry.subMenu.charCount"), msgs("example.ace.textAreaEntry.charCount.description"),
							 "textAreaEntry", "textAreaEntryCharCount.xhtml", "TextAreaEntryCharCountBean.java"),
					new Demo(msgs("menu.ace.textAreaEntry.subMenu.label"), msgs("example.ace.textAreaEntry.label.description"),
							 "textAreaEntry", "textAreaEntryLabel.xhtml", "TextAreaEntryLabelBean.java"),
					new Demo(msgs("menu.ace.textAreaEntry.subMenu.indicator"), msgs("example.ace.textAreaEntry.indicator.description"),
							 "textAreaEntry", "textAreaEntryIndicator.xhtml", "TextAreaEntryIndicatorBean.java"),
					new Demo(msgs("menu.ace.textAreaEntry.subMenu.reqStyle"), msgs("example.ace.textAreaEntry.reqStyle.description"),
							 "textAreaEntry", "textAreaEntryReqStyle.xhtml", "TextAreaEntryReqStyleBean.java")),
				new ComponentGroup("ace:textEntry", "TextEntry", "textEntry.html", "inputText, inputSecret",
					new Demo(msgs("overview"), msgs("example.ace.textEntry.description"),
							 "textEntry", "textEntry.xhtml", "TextEntryBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.autotab"), msgs("example.ace.textEntry.autotab.description"),
							 "textEntry", "textEntryAutotab.xhtml", "TextEntryAutotabBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.secret"), msgs("example.ace.textEntry.secret.description"),
							 "textEntry", "textEntrySecret.xhtml", "TextEntrySecretBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.charCount"), msgs("example.ace.textEntry.charCount.description"),
							 "textEntry", "textEntryCharCount.xhtml", "TextEntryCharCountBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.label"), msgs("example.ace.textEntry.label.description"),
							 "textEntry", "textEntryLabel.xhtml", "TextEntryLabelBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.indicator"), msgs("example.ace.textEntry.indicator.description"),
							 "textEntry", "textEntryIndicator.xhtml", "TextEntryIndicatorBean.java"),
					new Demo(msgs("menu.ace.textEntry.subMenu.reqStyle"), msgs("example.ace.textEntry.reqStyle.description"),
							 "textEntry", "textEntryReqStyle.xhtml", "TextEntryReqStyleBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.buttons.title"),
				new ComponentGroup("ace:buttonGroup", "ButtonGroup", "buttonGroup.html",
					new Demo(msgs("overview"), msgs("example.ace.buttonGroup.description"),
							 "buttonGroup", "buttongroup.xhtml", "ButtonGroupBean.java")),
				new ComponentGroup("ace:checkboxButton", "CheckboxButton", "checkboxButton.html",
					new Demo(msgs("overview"), msgs("example.ace.checkboxButton.description"),
							 "checkboxButton", "checkboxbutton.xhtml", "CheckboxButtonBean.java"),
					new Demo(msgs("menu.ace.checkboxButton.subMenu.custom"), msgs("example.ace.checkboxButton.custom.description"),
							 "checkboxButton", "checkboxbuttoncustom.xhtml", "CheckboxButtonCustomBean.java")),
				new ComponentGroup("ace:checkboxButtons", "CheckboxButtons", "checkboxButtons.html",
						new Demo(msgs("overview"), msgs("example.ace.checkboxButtons.description"),
								 "checkboxButtons", "checkboxButtons.xhtml", "CheckboxButtonsBean.java"),
						new Demo(msgs("menu.ace.checkboxButtons.subMenu.label"), msgs("example.ace.checkboxButtons.label.description"),
								 "checkboxButtons", "checkboxButtonsLabel.xhtml", "CheckboxButtonsLabelBean.java"),
						new Demo(msgs("menu.ace.checkboxButtons.subMenu.indicator"), msgs("example.ace.checkboxButtons.indicator.description"),
								 "checkboxButtons", "checkboxButtonsIndicator.xhtml", "CheckboxButtonsIndicatorBean.java"),
						new Demo(msgs("menu.ace.checkboxButtons.subMenu.reqStyle"), msgs("example.ace.checkboxButtons.reqStyle.description"),
								 "checkboxButtons", "checkboxButtonsReqStyle.xhtml", "CheckboxButtonsReqStyleBean.java")),
				new ComponentGroup("ace:linkButton", "LinkButton", "linkButton.html", "commandLink",
						new Demo(msgs("overview"), msgs("example.ace.linkButton.description"),
								 "linkButton", "linkbutton.xhtml", "LinkButtonBean.java"),
						new Demo(msgs("menu.ace.pushButton.subMenu.clearForm"), msgs("example.ace.pushButtonClearForm.description"),
								 "linkButton", "linkbuttonClearType.xhtml", "LinkButtonTypeBean.java")),
				new ComponentGroup("ace:menuButton", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:menuButton", "MenuButton"),
						new DemoResource(DemoResource.Type.WIKI, "ace:menuItem", "MenuItem"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuButton", "menuButton.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuItem", "menuItem.html")
				},
						new Demo(msgs("overview"), msgs("example.ace.menuButton.description"),
								 "menuButton", "menuButtonOverview.xhtml", "MenuButtonBean.java")),
				new ComponentGroup("ace:pushButton", "PushButton", "pushButton.html", "commandButton",
						new Demo(msgs("overview"), msgs("example.ace.pushButton.description"),
								 "pushButton", "pushbutton.xhtml", "PushButtonBean.java"),
						new Demo(msgs("menu.ace.pushButton.subMenu.clearForm"), msgs("example.ace.pushButtonClearForm.description"),
								 "pushButton", "pushbuttonClearType.xhtml", "PushButtonTypeBean.java")),
				new ComponentGroup("ace:radioButton", "RadioButton", "radioButton.html",
						new Demo(msgs("overview"), msgs("example.ace.radioButton.description"),
								 "radioButton", "radiobutton.xhtml", "RadioButtonBean.java"),
						new Demo(msgs("menu.ace.radioButton.subMenu.custom"), msgs("example.ace.radioButton.custom.description"),
								 "radioButton", "radiobuttoncustom.xhtml", "RadioButtonCustomBean.java")),
				new ComponentGroup("ace:radioButtons", "RadioButtons", "radioButtons.html",
						new Demo(msgs("overview"), msgs("example.ace.radioButtons.description"),
								 "radioButtons", "radioButtons.xhtml", "RadioButtonsBean.java"),
						new Demo(msgs("menu.ace.radioButtons.subMenu.label"), msgs("example.ace.radioButtons.label.description"),
								 "radioButtons", "radioButtonsLabel.xhtml", "RadioButtonsLabelBean.java"),
						new Demo(msgs("menu.ace.radioButtons.subMenu.indicator"), msgs("example.ace.radioButtons.indicator.description"),
								 "radioButtons", "radioButtonsIndicator.xhtml", "RadioButtonsIndicatorBean.java"),
						new Demo(msgs("menu.ace.radioButtons.subMenu.reqStyle"), msgs("example.ace.radioButtons.reqStyle.description"),
								 "radioButtons", "radioButtonsReqStyle.xhtml", "RadioButtonsReqStyleBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.selection.title"),
				new ComponentGroup("ace:autoCompleteEntry", "AutoCompleteEntry", "autoCompleteEntry.html",
					new Demo(msgs("overview"), msgs("example.ace.autocompleteentry.description"),
							 "autocompleteentry", "autoCompleteEntry.xhtml", "AutoCompleteEntryBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.select"), msgs("example.ace.autocompleteentry.select.description"),
							 "autocompleteentry", "autoCompleteEntrySelect.xhtml", "AutoCompleteEntrySelectBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.facet"), msgs("example.ace.autocompleteentry.facet.description"),
							 "autocompleteentry", "autoCompleteEntryFacet.xhtml", "AutoCompleteEntryFacetBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.match"), msgs("example.ace.autocompleteentry.match.description"),
							 "autocompleteentry", "autoCompleteEntryMatch.xhtml", "AutoCompleteEntryMatchBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.rows"), msgs("example.ace.autocompleteentry.rows.description"),
							 "autocompleteentry", "autoCompleteEntryRows.xhtml", "AutoCompleteEntryRowsBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.lazy"), msgs("example.ace.autocompleteentry.lazy.description"),
							 "autocompleteentry", "autoCompleteEntryLazy.xhtml", "AutoCompleteEntryLazyBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.label"), msgs("example.ace.autocompleteentry.label.description"),
							 "autocompleteentry", "autoCompleteEntryLabel.xhtml", "AutoCompleteEntryLabelBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.indicator"), msgs("example.ace.autocompleteentry.indicator.description"),
							 "autocompleteentry", "autoCompleteEntryIndicator.xhtml", "AutoCompleteEntryIndicatorBean.java"),
					new Demo(msgs("menu.ace.autocompleteentry.subMenu.reqStyle"), msgs("example.ace.autocompleteentry.reqStyle.description"),
							 "autocompleteentry", "autoCompleteEntryReqStyle.xhtml", "AutoCompleteEntryReqStyleBean.java")),
				new ComponentGroup("ace:comboBox", "ComboBox", "comboBox.html",
						new Demo(msgs("overview"), msgs("example.ace.combobox.description"),
								 "combobox", "comboBoxOverview.xhtml", "ComboBoxBean.java"),
						new Demo(msgs("menu.ace.combobox.subMenu.facet"), msgs("example.ace.combobox.facet.description"),
								 "combobox", "comboBoxFacet.xhtml", "ComboBoxFacetBean.java"),
						new Demo(msgs("menu.ace.combobox.subMenu.filtering"), msgs("example.ace.combobox.filtering.description"),
								 "combobox", "comboBoxFiltering.xhtml", "ComboBoxFilteringBean.java"),
						new Demo(msgs("menu.ace.combobox.subMenu.label"), msgs("example.ace.combobox.label.description"),
								 "combobox", "comboBoxLabel.xhtml", "ComboBoxLabelBean.java"),
						new Demo(msgs("menu.ace.combobox.subMenu.indicator"), msgs("example.ace.combobox.indicator.description"),
								 "combobox", "comboBoxIndicator.xhtml", "ComboBoxIndicatorBean.java"),
						new Demo(msgs("menu.ace.combobox.subMenu.reqStyle"), msgs("example.ace.combobox.reqStyle.description"),
								 "combobox", "comboBoxReqStyle.xhtml", "ComboBoxReqStyleBean.java")),
				new ComponentGroup("ace:list", "List", "list.html",
						new Demo(msgs("overview"), msgs("example.ace.list.description"),
								 "list", "list.xhtml", "ListBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.selection"), msgs("example.ace.list.selection.description"),
								 "list", "listSelection.xhtml", "ListSelectionBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.selectionAjax"), msgs("example.ace.list.selectionAjax.description"),
								 "list", "listSelectionAjax.xhtml", "ListSelectionAjaxBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.selectionMini"), msgs("example.ace.list.selectionMini.description"),
								 "list", "listSelectionMini.xhtml", "ListSelectionMiniBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.reordering"), msgs("example.ace.list.reorder.description"),
								 "list", "listReorder.xhtml", "ListReorderBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.reorderingAjax"), msgs("example.ace.list.reorderAjax.description"),
								 "list", "listReorderAjax.xhtml", "ListReorderAjaxBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.drag"), msgs("example.ace.list.drag.description"),
								 "list", "listDrag.xhtml", "ListDragBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.dual"), msgs("example.ace.list.dual.description"),
								 "list", "listDual.xhtml", "ListDualBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.multi"), msgs("example.ace.list.multi.description"),
								 "list", "listMulti.xhtml", "ListMultiBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.block"), msgs("example.ace.list.block.description"),
								 "list", "listBlock.xhtml", "ListBlockBean.java"),
						new Demo(msgs("menu.ace.list.subMenu.blockComplex"), msgs("example.ace.list.blockComplex.description"),
								 "list", "listBlockComplex.xhtml", "ListBlockComplexBean.java")),
				new ComponentGroup("ace:selectMenu", "SelectMenu", "selectMenu.html",
						new Demo(msgs("overview"), msgs("example.ace.selectmenu.description"),
								 "selectmenu", "selectMenuOverview.xhtml", "SelectMenuBean.java"),
						new Demo(msgs("menu.ace.selectmenu.subMenu.facet"), msgs("example.ace.selectmenu.facet.description"),
								 "selectmenu", "selectMenuFacet.xhtml", "SelectMenuFacetBean.java"),
						new Demo(msgs("menu.ace.selectmenu.subMenu.label"), msgs("example.ace.selectmenu.label.description"),
								 "selectmenu", "selectMenuLabel.xhtml", "SelectMenuLabelBean.java"),
						new Demo(msgs("menu.ace.selectmenu.subMenu.indicator"), msgs("example.ace.selectmenu.indicator.description"),
								 "selectmenu", "selectMenuIndicator.xhtml", "SelectMenuIndicatorBean.java"),
						new Demo(msgs("menu.ace.selectmenu.subMenu.reqStyle"), msgs("example.ace.selectmenu.reqStyle.description"),
								 "selectmenu", "selectMenuReqStyle.xhtml", "SelectMenuReqStyleBean.java")),
				new ComponentGroup("ace:simpleSelectOneMenu", "SimpleSelectOneMenu", "simpleSelectOneMenu.html",
						new Demo(msgs("overview"), msgs("example.ace.simpleselectonemenu.description"),
								 "simpleselectonemenu", "simpleSelectOneMenuOverview.xhtml", "SimpleSelectOneMenuBean.java"),
						new Demo(msgs("menu.ace.simpleselectonemenu.subMenu.label"), msgs("example.ace.simpleselectonemenu.label.description"),
								 "simpleselectonemenu", "simpleSelectOneMenuLabel.xhtml", "SimpleSelectOneMenuLabelBean.java"),
						new Demo(msgs("menu.ace.simpleselectonemenu.subMenu.indicator"), msgs("example.ace.simpleselectonemenu.indicator.description"),
								 "simpleselectonemenu", "simpleSelectOneMenuIndicator.xhtml", "SimpleSelectOneMenuIndicatorBean.java"),
						new Demo(msgs("menu.ace.simpleselectonemenu.subMenu.reqStyle"), msgs("example.ace.simpleselectonemenu.reqStyle.description"),
								 "simpleselectonemenu", "simpleSelectOneMenuReqStyle.xhtml", "SimpleSelectOneMenuReqStyleBean.java")),
				new ComponentGroup("ace:themeSelect", "ThemeSelect", "themeSelect.html",
						new Demo(msgs("overview"), msgs("example.ace.themeSelect.description"),
								 "themeSelect", "themeSelect.xhtml", "ThemeSelectBean.java"),
						new Demo(msgs("menu.ace.themeSelect.subMenu.label"), msgs("example.ace.themeSelect.label.description"),
								 "themeSelect", "themeSelectLabel.xhtml", "ThemeSelectLabelBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.datatable.title"),
				new ComponentGroup("ace:dataTable", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:dataTable", "DataTable"),
						new DemoResource(DemoResource.Type.WIKI, "ace:column", "Column"),
						new DemoResource(DemoResource.Type.WIKI, "ace:expansionToggler", "ExpansionToggler"),
						new DemoResource(DemoResource.Type.TLD, "ace:dataTable", "dataTable.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:column", "column.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:expansionToggler", "expansionToggler.html"),
				}, "tabular, spreadsheet, grid",
					new Demo(msgs("overview"), msgs("example.ace.dataTable.description"),
							new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "dataTable.xhtml", "dataTable"), 
											    new DemoSource(DemoSource.Type.JAVA, "DataTableBean.java", "dataTable"),
											    new DemoSource(DemoSource.Type.JAVA, "Car.java", "dataTable") } ),
					new Demo(msgs("menu.ace.dataTable.subMenu.click"), msgs("example.ace.dataTable.click.description"),
							 "dataTable", "dataTableClick.xhtml", "DataTableClick.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.columnReordering"), msgs("example.ace.dataTable.columnReordering.description"),
							 "dataTable", "dataTableColumnReordering.xhtml", "DataTableColumnReordering.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.columnResizing"), msgs("example.ace.dataTable.columnResizing.description"),
							 "dataTable", "dataTableResizableColumns.xhtml", "DataTableColumnResizing.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.stackable"), msgs("example.ace.dataTable.stackable.description"),
							 "dataTable", "dataTableStackable.xhtml", "DataTableStackable.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.dynamicColumns"), msgs("example.ace.dataTable.dynamicColumns.description"),
							 "dataTable", "dataTableDynamicColumns.xhtml", "DataTableDynamicColumns.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.filtering"), msgs("example.ace.dataTable.filtering.description"),
							 "dataTable", "dataTableFiltering.xhtml", "DataTableFiltering.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.filteringDates"), msgs("example.ace.dataTable.filteringDates.description"),
							 "dataTable", "dataTableFilteringDates.xhtml", "DataTableFilteringDates.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.filteringRanges"), msgs("example.ace.dataTable.filteringRanges.description"),
							 "dataTable", "dataTableFilteringRanges.xhtml", "DataTableFilteringRanges.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.find"), msgs("example.ace.dataTable.find.description"),
							 "dataTable", "dataTableFind.xhtml", "DataTableFind.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.grouping"), msgs("example.ace.dataTable.grouping.description"),
							 "dataTable", "dataTableGrouping.xhtml", "DataTableGrouping.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.lazyLoading"), msgs("example.ace.dataTable.lazyLoading.description"),
							 "dataTable", "dataTableLazyLoading.xhtml", "DataTableLazyLoading.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.liveScrolling"), msgs("example.ace.dataTable.liveScrolling.description"),
							 "dataTable", "dataTableLiveScrolling.xhtml", "DataTableLiveScrolling.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.paginator"), msgs("example.ace.dataTable.paginator.description"),
							 "dataTable", "dataTablePaginator.xhtml", "DataTablePaginator.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.panelexpansion"), msgs("example.ace.dataTable.panelexpansion.description"),
							 "dataTable", "dataTablePanelExpansion.xhtml", "DataTablePanelExpansion.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.pinning"), msgs("example.ace.dataTable.pinning.description"),
							 "dataTable", "dataTablePinning.xhtml", "DataTablePinning.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.listener"), msgs("example.ace.dataTable.listener.description"),
							 "dataTable", "dataTableListener.xhtml", "DataTableListener.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.rowstate"), msgs("example.ace.dataTable.rowstate.description"),
							 "dataTable", "dataTableRowState.xhtml", "DataTableRowState.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.selector"), msgs("example.ace.dataTable.selector.description"),
							 "dataTable", "dataTableSelector.xhtml", "DataTableSelector.java"),					
					new Demo(msgs("menu.ace.dataTable.subMenu.scrolling"), msgs("example.ace.dataTable.scrolling.description"),
							 "dataTable", "dataTableScrolling.xhtml", "DataTableScrolling.java"),
					new Demo(msgs("menu.ace.dataTable.subMenu.sorting"), msgs("example.ace.dataTable.sorting.description"),
							 "dataTable", "dataTableSorting.xhtml", "DataTableSorting.java")),
				new ComponentGroup("ace:cellEditor", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:cellEditor", "CellEditor"),
						new DemoResource(DemoResource.Type.WIKI, "ace:rowEditor", "RowEditor"),
						new DemoResource(DemoResource.Type.TLD, "ace:cellEditor", "cellEditor.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:rowEditor", "rowEditor.html")
				},
						new Demo(msgs("overview"), msgs("example.ace.cellEditor.description"),
								 "cellEditor", "cellEditor.xhtml", "CellEditorBean.java")),
				new ComponentGroup("ace:columnGroup", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:columnGroup", "ColumnGroup"),
						new DemoResource(DemoResource.Type.WIKI, "ace:row", "Row"),
						new DemoResource(DemoResource.Type.TLD, "ace:columnGroup", "columnGroup.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:row", "row.html")
				},
						new Demo(msgs("overview"), msgs("example.ace.columnGroup.description"),
								 "columnGroup", "columnGroup.xhtml", "ColumnGroupBean.java")),
				new ComponentGroup("ace:dataExporter", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:dataExporter", "DataExporter"),
						new DemoResource(DemoResource.Type.WIKI, "ace:excludeFromExport", "ExludeFromExport"),
						new DemoResource(DemoResource.Type.TLD, "ace:dataExporter", "dataExporter.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:excludeFromExport", "excludeFromExport.html")
				},
						new Demo(msgs("overview"), msgs("example.ace.dataExporter.description"),
								 "dataExporter", "dataExporter.xhtml", "DataExporterBean.java"),
						new Demo(msgs("menu.ace.dataExporter.subMenu.columns"), msgs("example.ace.dataExporter.columns.description"),
								 "dataExporter", "dataExporterColumns.xhtml", "DataExporterColumns.java"),
						new Demo(msgs("menu.ace.dataExporter.subMenu.rows"), msgs("example.ace.dataExporter.rows.description"),
								 "dataExporter", "dataExporterRows.xhtml", "DataExporterRows.java"),
						new Demo(msgs("menu.ace.dataExporter.subMenu.excludeFromExport"), msgs("example.ace.dataExporter.excludeFromExport.description"),
								 "dataExporter", "dataExporterExcludeFromExport.xhtml", "ExcludeFromExport.java"),
						new Demo(msgs("menu.ace.dataExporter.subMenu.custom"), msgs("example.ace.dataExporter.custom.description"),
								 "dataExporter", "dataExporterCustom.xhtml", "DataExporterCustom.java")),
				new ComponentGroup("ace:rowExpansion", "RowExpansion", "rowExpansion.html",
						new Demo(msgs("overview"), msgs("example.ace.rowExpansion.description"),
								 "rowExpansion", "rowExpansion.xhtml", "RowExpansionBean.java")),
				new ComponentGroup("ace:tableConfigPanel", "TableConfigPanel", "tableConfigPanel.html",
						new Demo(msgs("overview"), msgs("example.ace.tableConfigPanel.description"),
								 "tableConfigPanel", "tableConfigPanel.xhtml", "TableConfigPanelBean.java"),
						new Demo(msgs("menu.ace.tableConfigPanel.subMenu.advanced"), msgs("example.ace.tableConfigPanel.advanced.description"),
								 "tableConfigPanel", "tableConfigPanelAdvanced.xhtml", "TableConfigPanelAdvancedBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.containers.title"),
				new ComponentGroup("ace:accordion", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:accordion", "Accordion"),
						new DemoResource(DemoResource.Type.WIKI, "ace:accordionPane", "AccordionPane"),
						new DemoResource(DemoResource.Type.TLD, "ace:accordion", "accordion.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:accordionPane", "accordionPane.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.accordionpanel.description"),
							 "accordionpanel", "accordionPanel.xhtml", "AccordionPanelBean.java"),
					new Demo(msgs("menu.ace.accordionpanel.subMenu.dynamic"), msgs("example.ace.accordionpanel.dynamic.description"),
							 "accordionpanel", "accordionPanelDynamic.xhtml", "AccordionPanelDynamicBean.java"),
					new Demo(msgs("menu.ace.accordionpanel.subMenu.effect"), msgs("example.ace.accordionpanel.effect.description"),
							 "accordionpanel", "accordionPanelEffect.xhtml", "AccordionPanelEffectBean.java")),
				new ComponentGroup("ace:panel", "Panel", "panel.html",
						new Demo(msgs("overview"), msgs("example.ace.panel.description"),
								 "panel", "panel.xhtml", "PanelBean.java"),
						new Demo(msgs("menu.ace.panel.subMenu.header"), msgs("example.ace.panel.header.description"),
								 "panel", "panelHeader.xhtml", "PanelHeader.java"),
						new Demo(msgs("menu.ace.panel.subMenu.toggle"), msgs("example.ace.panel.toggle.description"),
								 "panel", "panelToggle.xhtml", "PanelToggle.java"),
						new Demo(msgs("menu.ace.panel.subMenu.close"), msgs("example.ace.panel.close.description"),
								 "panel", "panelClose.xhtml", "PanelClose.java"),
						new Demo(msgs("menu.ace.panel.subMenu.listener"), msgs("example.ace.panel.listener.description"),
								 "panel", "panelListener.xhtml", "PanelListener.java"),
						new Demo(msgs("menu.ace.panel.subMenu.menu"), msgs("example.ace.panel.menu.description"),
								 "panel", "panelMenu.xhtml", "PanelMenu.java")),
				new ComponentGroup("ace:panelStack", "PanelStack", "panelStack.html",
						new Demo(msgs("overview"), msgs("example.ace.panelStack.description"),
								 "panelStack", "panelStackOverview.xhtml", "PanelStackBean.java"),
						new Demo(msgs("menu.ace.panelStack.subMenu.client"), msgs("example.ace.panelStack.client.description"),
								 "panelStack", "panelStackClient.xhtml", "PanelStackClient.java"),
						new Demo(msgs("menu.ace.panelStack.subMenu.facelet"), msgs("example.ace.panelStack.facelet.description"),
								 "panelStack", "panelStackFacelet.xhtml", "PanelStackFacelet.java")),
				new ComponentGroup("ace:splitPane", "SplitPane", "splitPane.html",
						new Demo(msgs("overview"), msgs("example.ace.splitpane.description"),
								 "splitpane", "splitPaneOverview.xhtml", "SplitPaneBean.java")),
				new ComponentGroup("ace:tabSet", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:tabPane", "TabPane"),
						new DemoResource(DemoResource.Type.WIKI, "ace:tabSet", "TabSet"),
						new DemoResource(DemoResource.Type.WIKI, "ace:tabSetProxy", "TabSetProxy"),
						new DemoResource(DemoResource.Type.TLD, "ace:tabPane", "tabPane.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:tabSet", "tabSet.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:tabSetProxy", "tabSetProxy.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.tabSet.description"),
							 "tab", "tabset.xhtml", "TabSetBean.java"),
					new Demo(msgs("menu.ace.tabSet.subMenu.clientSide"), msgs("example.ace.tabSet.clientSide.description"),
							 "tab", "tabset-client_side.xhtml", "TabClientSideBean.java"),
					new Demo(msgs("menu.ace.tabSet.subMenu.serverSide"), msgs("example.ace.tabSet.serverSide.description"),
							 "tab", "tabset-server_side.xhtml", "TabServerSideBean.java"),
					new Demo(msgs("menu.ace.tabSet.subMenu.proxy"), msgs("example.ace.tabSet.proxy.description"),
							 "tab", "tabset-proxy.xhtml", "TabProxyBean.java")),
				new ComponentGroup("ace:tree", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:tree", "Tree"),
						new DemoResource(DemoResource.Type.TLD, "ace:tree", "tree.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:node", "node.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.tree.description"),
							 "tree", "tree.xhtml", "TreeBean.java"),
					new Demo(msgs("menu.ace.tree.subMenu.lazy"), msgs("example.ace.tree.lazy.description"),
							 "tree", "treeLazy.xhtml", "TreeLazyBean.java"),
					new Demo(msgs("menu.ace.tree.subMenu.client"), msgs("example.ace.tree.client.description"),
							 "tree", "treeClient.xhtml", "TreeClientBean.java"),
					new Demo(msgs("menu.ace.tree.subMenu.reorder"), msgs("example.ace.tree.reorder.description"),
							 "tree", "treeReorder.xhtml", "TreeReorderBean.java"),
					new Demo(msgs("menu.ace.tree.subMenu.selection"), msgs("example.ace.tree.selection.description"),
							 "tree", "treeSelection.xhtml", "TreeSelectionBean.java"),
					new Demo(msgs("menu.ace.tree.subMenu.expansion"), msgs("example.ace.tree.expansion.description"),
							 "tree", "treeExpansion.xhtml", "TreeExpansionBean.java"))
		));

		toReturn.add(new CategoryGroup(msgs("menu.ace.group.dialogs.title"),
			new ComponentGroup("ace:confirmationDialog", "ConfirmationDialog", "confirmationDialog.html",
					new Demo(msgs("overview"), msgs("example.ace.confirmationdialog.description"),
							 "confirmationdialog", "confirmationDialog.xhtml", "ConfirmationDialogBean.java"),
					new Demo(msgs("menu.ace.confirmationdialog.subMenu.modal"), msgs("example.ace.confirmationdialog.modal.description"),
							 "confirmationdialog", "confirmationDialogModal.xhtml", "ConfirmationDialogModalBean.java"),
					new Demo(msgs("menu.ace.confirmationdialog.subMenu.effect"), msgs("example.ace.confirmationdialog.effect.description"),
							 "confirmationdialog", "confirmationDialogEffect.xhtml", "ConfirmationDialogEffectBean.java")),
			new ComponentGroup("ace:dialog", "Dialog", "dialog.html", "popup window",
					new Demo(msgs("overview"), msgs("example.ace.dialog.description"),
							 "dialog", "dialog.xhtml", "DialogBean.java"),
					new Demo(msgs("menu.ace.dialog.subMenu.modalDialog"), msgs("example.ace.dialog.modalDialog.description"),
							 "dialog", "modalDialog.xhtml", "ModalDialogBean.java"),
                    new Demo(msgs("menu.ace.dialog.subMenu.serverDialog"), msgs("example.ace.dialog.serverDialog.description"),
							 "dialog", "dialogServer.xhtml", "DialogServerBean.java"),
					new Demo(msgs("menu.ace.dialog.subMenu.effectsAndSize"), msgs("example.ace.dialog.dialogEffectAndSize.description"),
							 "dialog", "dialogEffectsAndSize.xhtml", "DialogEffectsAndSizeBean.java")),
			new ComponentGroup("ace:notificationPanel", "NotificationPanel", "notificationPanel.html",
					new Demo(msgs("menu.ace.notificationpanel.subMenu.main"), msgs("example.ace.notificationpanel.description"),
							 "notificationpanel", "notificationPanel.xhtml", "NotificationPanelBean.java"),
					new Demo(msgs("menu.ace.notificationpanel.subMenu.clientSide"), msgs("example.ace.notificationpanel.client.description"),
							 "notificationpanel", "notificationPanelClient.xhtml", "NotificationPanelClientBean.java")),
			new ComponentGroup("ace:tooltip", "Tooltip", "tooltip.html",
					new Demo(msgs("overview"), msgs("example.ace.tooltip.description"),
							 "tooltip", "toolTip.xhtml", "TooltipOverviewBean.java"),
					new Demo(msgs("menu.ace.tooltip.subMenu.globalTooltip"), msgs("example.ace.globalTooltip.description"),
							 "tooltip", "globalTooltip.xhtml", "GlobalTooltipBean.java"),
					new Demo(msgs("menu.ace.tooltip.subMenu.delegateTooltip"), msgs("example.ace.delegateTooltip.description"),
							 "tooltip", "delegateTooltip.xhtml", "DelegateTooltipBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.menus.title"),
				new ComponentGroup("ace:breadcrumbMenu", "BreadcrumbMenu", "breadcrumbMenu.html",
						new Demo(msgs("overview"), msgs("example.ace.breadcrumbmenu.description"),
								 "breadcrumbmenu", "breadcrumbMenu.xhtml", "BreadcrumbMenuBean.java")),
				new ComponentGroup("ace:contextMenu", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:contextMenu", "ContextMenu"),
						new DemoResource(DemoResource.Type.WIKI, "ace:menuItem", "MenuItem"),
						new DemoResource(DemoResource.Type.TLD, "ace:contextMenu", "contextMenu.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuItem", "menuItem.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.contextMenu.description"),
							 "contextMenu", "contextMenu.xhtml", "ContextMenuBean.java"),
					new Demo(msgs("menu.ace.contextMenu.subMenu.component"), msgs("example.ace.contextMenu.component.description"),
							 "contextMenu", "contextMenuComponent.xhtml", "ContextMenuComponent.java"),
					new Demo(msgs("menu.ace.contextMenu.subMenu.table"), msgs("example.ace.contextMenu.table.description"),
							 "contextMenu", "contextMenuTable.xhtml", "ContextMenuTable.java"),
					new Demo(msgs("menu.ace.contextMenu.subMenu.effect"), msgs("example.ace.contextMenu.effect.description"),
							 "contextMenu", "contextMenuEffect.xhtml", "ContextMenuEffect.java"),
					new Demo(msgs("menu.ace.contextMenu.subMenu.delegate"), msgs("example.ace.contextMenu.delegate.description"),
							 "contextMenu", "contextMenuDelegate.xhtml", "ContextMenuDelegate.java")),
				new ComponentGroup("ace:menu", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:menu", "Menu+and+Menubar"),
						new DemoResource(DemoResource.Type.WIKI, "ace:menuItem", "MenuItem"),
						new DemoResource(DemoResource.Type.WIKI, "ace:subMenu", "SubMenu"),
						new DemoResource(DemoResource.Type.TLD, "ace:menu", "menu.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuItem", "menuItem.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:subMenu", "submenu.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.menu.description"),
							 "menu", "menu.xhtml", "MenuBean.java"),
					new Demo(msgs("menu.ace.menu.subMenu.type"), msgs("example.ace.menu.type.description"),
							 "menu", "menuType.xhtml", "MenuType.java"),
					new Demo(msgs("menu.ace.menu.subMenu.events"), msgs("example.ace.menu.events.description"),
							 "menu", "menuEvents.xhtml", "MenuEvents.java"),
					new Demo(msgs("menu.ace.menu.subMenu.effect"), msgs("example.ace.menu.effect.description"),
							 "menu", "menuEffect.xhtml", "MenuEffect.java"),
					new Demo(msgs("menu.ace.menu.subMenu.display"), msgs("example.ace.menu.display.description"),
							 "menu", "menuDisplay.xhtml", "MenuDisplay.java")),
				new ComponentGroup("ace:menuBar", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:menu", "Menu+and+Menubar"),
						new DemoResource(DemoResource.Type.WIKI, "ace:menuItem", "MenuItem"),
						new DemoResource(DemoResource.Type.WIKI, "ace:subMenu", "SubMenu"),
						new DemoResource(DemoResource.Type.WIKI, "ace:multiColumnSubmenu", "MultiColumnSubmenu"),
						new DemoResource(DemoResource.Type.TLD, "ace:menu", "menu.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuItem", "menuItem.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:subMenu", "submenu.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:multiColumnSubmenu", "multiColumnSubmenu.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.menuBar.description"),
							 "menuBar", "menuBar.xhtml", "MenuBarBean.java"),
					new Demo(msgs("menu.ace.menuBar.subMenu.effect"), msgs("example.ace.menuBar.effect.description"),
							 "menuBar", "menuBarEffect.xhtml", "MenuBarEffect.java"),
					new Demo(msgs("menu.ace.menuBar.subMenu.click"), msgs("example.ace.menuBar.click.description"),
							 "menuBar", "menuBarClick.xhtml", "MenuBarClick.java"),
					new Demo(msgs("menu.ace.menuBar.subMenu.dynamic"), msgs("example.ace.menuBar.dynamic.description"),
							 "menuBar", "menuBarDynamic.xhtml", "MenuBarDynamic.java")),
				new ComponentGroup("ace:menuButton", new DemoResource[] {
						new DemoResource(DemoResource.Type.WIKI, "ace:menuButton", "MenuButton"),
						new DemoResource(DemoResource.Type.WIKI, "ace:menuItem", "MenuItem"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuButton", "menuButton.html"),
						new DemoResource(DemoResource.Type.TLD, "ace:menuItem", "menuItem.html")
				},
					new Demo(msgs("overview"), msgs("example.ace.menuButton.description"),
							 "menuButton", "menuButtonOverview.xhtml", "MenuButtonBean.java")),
				new ComponentGroup("ace:menuSeparator", "MenuSeparator", "menuSeparator.html",
						new Demo(msgs("overview"), msgs("example.ace.menuSeparator.description"),
								 "menuSeparator", "menuSeparator.xhtml", "MenuSeparatorBean.java")),
				new ComponentGroup("ace:multiColumnSubmenu", "MultiColumnSubmenu", "multiColumnSubmenu.html",
						new Demo(msgs("overview"), msgs("example.ace.multiColumnSubmenu.description"),
								 "multiColumnSubmenu", "multiColumnSubmenu.xhtml", "MultiColumnSubmenuBean.java"),
						new Demo(msgs("menu.ace.multiColumnSubmenu.subMenu.headerfooter"), msgs("example.ace.multiColumnSubmenu.headerfooter.description"),
								 "multiColumnSubmenu", "multiColumnSubmenuHeaderFooter.xhtml", "MultiColumnSubmenuBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.messages.title"),
				new ComponentGroup("ace:growlMessages", "GrowlMessages", "growlMessages.html",
					new Demo(msgs("overview"), msgs("example.ace.growlmessages.description"),
							 "growlmessages", "growlmessages.xhtml", "GrowlMessagesBean.java")),
				new ComponentGroup("ace:message", "Message", "message.html",
						new Demo(msgs("overview"), msgs("example.ace.message.description"),
								 "message", "message.xhtml", "MessageBean.java")),
				new ComponentGroup("ace:messages", "Messages", "messages.html",
						new Demo(msgs("overview"), msgs("example.ace.messages.description"),
								 "messages", "messages.xhtml", "MessagesBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.file.title"),
				new ComponentGroup("ace:dynamicResource", "DynamicResource", "dynamicResource.html", "file download",
					new Demo(msgs("overview"), msgs("example.ace.dynamicResource.description"),
							 "dynamicResource", "dynamicResource.xhtml", "DynamicResourceBean.java"),
					new Demo(msgs("menu.ace.dynamicResource.subMenu.advanced"), msgs("example.ace.dynamicResource.advanced.description"),
							 "dynamicResource", "dynamicResourceAdvanced.xhtml", "DynamicResourceAdvancedBean.java")),
				new ComponentGroup("ace:fileEntry", "FileEntry", "fileEntry.html",
						new Demo(msgs("overview"), msgs("example.ace.fileentry.description"),
								 "fileentry", "fileentry.xhtml", "FileEntryBean.java"),
						new Demo(msgs("menu.ace.fileentry.subMenu.listener"), msgs("example.ace.fileentry.listener.description"),
								 "fileentry", "fileEntryListener.xhtml", "FileEntryListenerBean.java"),
						new Demo(msgs("menu.ace.fileentry.subMenu.validation"), msgs("example.ace.fileentry.valid.description"),
								 "fileentry", "fileEntryValidation.xhtml", "FileEntryValidationOptionsBean.java"),
						new Demo(msgs("menu.ace.fileentry.subMenu.callback"), msgs("example.ace.fileentry.callback.description"),
								 "fileentry", "fileEntryCallback.xhtml", "FileEntryCallbackBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.charts.title"),
				new ComponentGroup("ace:chart", "Chart", "chart.html", "graph",
						new Demo(msgs("overview"), msgs("example.ace.chart.description"),
								 "chart", "chart.xhtml", "ChartBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.bar"), msgs("example.ace.chart.bar.description"),
								 "chart", "chartBar.xhtml", "ChartBarBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.bubble"), msgs("example.ace.chart.bubble.description"),
								 "chart", "chartBubble.xhtml", "ChartBubbleBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.candlestick"), msgs("example.ace.chart.candlestick.description"),
								 "chart", "chartCandlestick.xhtml", "ChartCandlestickBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.donut"), msgs("example.ace.chart.donut.description"),
								 "chart", "chartDonut.xhtml", "ChartDonutBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.gauge"), msgs("example.ace.chart.gauge.description"),
								 "chart", "chartGauge.xhtml", "ChartGaugeBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.line"), msgs("example.ace.chart.line.description"),
								 "chart", "chartLine.xhtml", "ChartLineBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.pie"), msgs("example.ace.chart.pie.description"),
								 "chart", "chartPie.xhtml", "ChartPieBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.combined"), msgs("example.ace.chart.combined.description"),
								 "chart", "chartCombined.xhtml", "ChartCombinedBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.color"), msgs("example.ace.chart.color.description"),
								 "chart", "chartColor.xhtml", "ChartColorBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.stacked"), msgs("example.ace.chart.stackedFill.description"),
								 "chart", "chartStackedBar.xhtml", "ChartStackedBarBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.dynamic"), msgs("example.ace.chart.dynamic.description"),
								 "chart", "chartDynamic.xhtml", "ChartDynamicBean.java"),
						new Demo(msgs("menu.ace.chart.subMenu.export"), msgs("example.ace.chart.export.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "chartExport.xhtml", "chart"),
													new DemoSource(DemoSource.Type.JAVA, "ChartExportBean.java", "chart"),
												    new DemoSource(DemoSource.Type.JAVA, "ChartCombinedBean.java", "chart") }))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.mapping.title"),
				new ComponentGroup("ace:gMap", "GMap", "gMap.html", true,
					new Demo(msgs("overview"), msgs("example.ace.gMap.overview.description"),
							 "gMap", "gMapBasic.xhtml", "MapBean.java"),
					new Demo(msgs("menu.ace.gMap.subMenu.options"), msgs("example.ace.gMap.options.description"),
							 "gMap", "gMapOptions.xhtml", "MapOptionsBean.java")),
				new ComponentGroup("ace:gMapAutoComplete", "GMap", "gMapAutocomplete.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapAutoComplete.description"),
								 "gMapAutoComplete", "gMapAutoComplete.xhtml", "GMapAutoCompleteBean.java")),
				new ComponentGroup("ace:gMapControl", "GMap", "gMapControl.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapControl.description"),
								 "gMapControl", "gMapControl.xhtml", "GMapControlBean.java")),
				new ComponentGroup("ace:gMapEvent", "GMap", "gMapEvent.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapEvent.description"),
								 "gMapEvent", "gMapEvent.xhtml", "GMapEventBean.java")),
				new ComponentGroup("ace:gMapInfoWindow", "GMap", "gMapInfoWindow.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapInfoWindow.description"),
								 "gMapInfoWindow", "gMapInfoWindow.xhtml", "GMapInfoWindowBean.java")),
				new ComponentGroup("ace:gMapLayer", "GMap", "gMapLayer.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapLayer.description"),
								 "gMapLayer", "gMapLayer.xhtml", "GMapLayerBean.java")),
				new ComponentGroup("ace:gMapMarker", "GMap", "gMapMarker.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapMarker.description"),
								 "gMapMarker", "gMapMarker.xhtml", "GMapMarkerBean.java")),
				new ComponentGroup("ace:gMapOverlay", "GMap", "gMapOverlay.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapOverlay.description"),
								 "gMapOverlay", "gMapOverlay.xhtml", "GMapOverlayBean.java")),
				new ComponentGroup("ace:gMapServices", "GMap", "gMapServices.html", true,
						new Demo(msgs("overview"), msgs("example.ace.gMapServices.description"),
								 "gMapServices", "gMapServices.xhtml", "GMapServicesBean.java"))
		));
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.media.title"),
				new ComponentGroup("ace:audioPlayer", "AudioPlayer", "audioPlayer.html", "sound",
						new Demo(msgs("overview"), msgs("example.ace.audioPlayer.description"),
								 "audioPlayer", "audioPlayer.xhtml", "AudioPlayerBean.java")),
				new ComponentGroup("ace:graphicImage", "GraphicImage", "graphicImage.html", "picture",
						new Demo(msgs("overview"), msgs("example.ace.graphicImage.description"),
								 "graphicImage", "graphicImage.xhtml", "GraphicImageBean.java")),
				new ComponentGroup("ace:videoPlayer", "VideoPlayer", "videoPlayer.html",
						new Demo(msgs("overview"), msgs("example.ace.videoPlayer.description"),
								 "videoPlayer", "videoPlayer.xhtml", "VideoPlayerBean.java"))
		));
	
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.validator.title"),
				new ComponentGroup("ace:clientValidateRequired", "ClientValidateRequired", "clientValidateRequired.html",
					new Demo(msgs("overview"), msgs("example.ace.clientValidateRequired.description"),
							"clientValidateRequired", "clientValidateRequired.xhtml", "ClientValidateRequiredBean.java")),
				new ComponentGroup("ace:clientValidateLength", "ClientValidateLength", "clientValidateLength.html",
					new Demo(msgs("menu.ace.clientValidateLength.subMenu.minimum"), msgs("example.ace.clientValidateLength.minimum.description"),
							"clientValidateLength", "clientValidateLengthMin.xhtml", "ClientValidateLengthBean.java"),
					new Demo(msgs("menu.ace.clientValidateLength.subMenu.maximum"), msgs("example.ace.clientValidateLength.maximum.description"),
							"clientValidateLength", "clientValidateLengthMax.xhtml", "ClientValidateLengthBean.java"),
					new Demo(msgs("menu.ace.clientValidateLength.subMenu.range"), msgs("example.ace.clientValidateLength.range.description"),
							"clientValidateLength", "clientValidateLengthRange.xhtml", "ClientValidateLengthBean.java")),
				new ComponentGroup("ace:clientValidateValueRange", "ClientValidateValueRange", "clientValidateValueRange.html",
					new Demo(msgs("menu.ace.clientValidateValueRange.subMenu.minimum"), msgs("example.ace.clientValidateValueRange.minimum.description"),
							"clientValidateValueRange", "clientValidateValueRangeMin.xhtml", "ClientValidateRangeBean.java"),
					new Demo(msgs("menu.ace.clientValidateValueRange.subMenu.maximum"), msgs("example.ace.clientValidateValueRange.maximum.description"),
							"clientValidateValueRange", "clientValidateValueRangeMax.xhtml", "ClientValidateRangeBean.java"),
					new Demo(msgs("menu.ace.clientValidateValueRange.subMenu.range"), msgs("example.ace.clientValidateValueRange.range.description"),
							"clientValidateValueRange", "clientValidateValueRangeMinMax.xhtml", "ClientValidateRangeBean.java")),
				new ComponentGroup("ace:clientValidateDecimal", "ClientValidateDecimal", "clientValidateDecimal.html",
					new Demo(msgs("overview"), msgs("example.ace.clientValidateDecimal.description"),
							"clientValidateDecimal", "clientValidateDecimal.xhtml", "ClientValidateDecimalBean.java")),
				new ComponentGroup("ace:clientValidatePattern", "ClientValidatePattern", "clientValidatePattern.html",
					new Demo(msgs("overview"), msgs("example.ace.clientValidatePattern.description"),
							"clientValidatePattern", "clientValidatePattern.xhtml", "ClientValidatePatternBean.java"))
					
		));
		
		
		toReturn.add(new CategoryGroup(msgs("menu.ace.group.misc.title"),
				new ComponentGroup("ace:animation", "Animation", "animation.html",
						new Demo(msgs("overview"), msgs("example.ace.animation.description"),
								 "animation", "animation.xhtml", "AnimationBean.java")),
				new ComponentGroup("ace:draggable/droppable", new DemoResource[] {
					new DemoResource(DemoResource.Type.WIKI, "ace:draggable", "Draggable"),
					new DemoResource(DemoResource.Type.WIKI, "ace:droppable", "Droppable"),
					new DemoResource(DemoResource.Type.TLD, "ace:draggable", "draggable.html"),
					new DemoResource(DemoResource.Type.TLD, "ace:droppable", "droppable.html"),
				},
						new Demo(msgs("overview"), msgs("example.ace.dragDrop.description"),
								 "dragDrop", "dragDropOverview.xhtml", "DragDropOverviewBean.java"),
						new Demo(msgs("menu.ace.dragDrop.subMenu.draggable"), msgs("example.ace.draggable.description"),
								 "dragDrop", "draggableOverview.xhtml", "DraggableOverviewBean.java"),
						new Demo(msgs("menu.ace.dragDrop.subMenu.dataTableIntegration"), msgs("example.ace.dataTableIntegration.description"),
								 "dragDrop", "dataTableIntegration.xhtml", "DataTableIntegrationBean.java")),
				new ComponentGroup("ace:printer", "Printer", "printer.html",
						new Demo(msgs("overview"), msgs("example.ace.printer.description"),
								 "printer", "printerOverview.xhtml", "PrinterBean.java")),
				new ComponentGroup("ace:progressBar", "ProgressBar", "progressBar.html",
						new Demo(msgs("overview"), msgs("example.ace.progressbar.description"),
								 "progressbar", "progressBar.xhtml", "ProgressBarBean.java"),
						new Demo(msgs("menu.ace.progressbar.subMenu.polling"), msgs("example.ace.progressBarPolling.description"),
								 "progressbar", "progressBarPolling.xhtml", "ProgressBarPolling.java"),
						new Demo(msgs("menu.ace.progressbar.subMenu.push"), msgs("example.ace.progressBarPush.description"),
								new DemoSource[] { new DemoSource(DemoSource.Type.XHTML, "progressBarPush.xhtml", "progressbar"),
											       new DemoSource(DemoSource.Type.JAVA, "ProgressBarPush.java", "progressbar"),
											       new DemoSource(DemoSource.Type.JAVA, "ProgressBarTaskManager.java", "progressbar") }),
						new Demo(msgs("menu.ace.progressbar.subMenu.client"), msgs("example.ace.progressBarClientSideOnly.description"),
								 "progressbar", "progressBarClient.xhtml", "ProgressBarClient.java"),
						new Demo(msgs("menu.ace.progressbar.subMenu.clientAndServer"), msgs("example.ace.progressBarClientAndServer.description"),
								 "progressbar", "progressBarClientAndServer.xhtml", "ProgressBarClientAndServer.java")),
				new ComponentGroup("ace:qrcode", "Qrcode", "qrcode.html",
						new Demo(msgs("overview"), msgs("example.ace.qrcode.description"),
								 "qrcode", "qrcodeOverview.xhtml", "QrCodeBean.java")),
				new ComponentGroup("ace:resizable", "Resizable", "resizable.html",
						new Demo(msgs("overview"), msgs("example.ace.resizable.description"),
								 "resizable", "resizable.xhtml", "ResizableBean.java"),
						new Demo(msgs("menu.ace.resizable.subMenu.resizeListener"), msgs("example.ace.resizableListener.description"),
								 "resizable", "resizeListener.xhtml", "ResizeListenerBean.java"))
		));
		
		return toReturn;
	}
	
	private static String msgs(String key) {
		return FacesUtils.getJSFMessageResourceString("msgs", key);
	}
}
