/*
 * Copyright 2004-2014 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.icefaces.samples.showcase.example.ace.fileentry;

import java.io.Serializable;

import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;

@ManagedBean(name= FileEntryValidationOptionsBean.BEAN_NAME)
@CustomScoped(value = "#{window}")
public class FileEntryValidationOptionsBean implements Serializable {
    public static final String BEAN_NAME = "fileEntryValidation";
	public String getBeanName() { return BEAN_NAME; }

    private boolean maxFileSizeSet = false;
    private Integer maxFileSize = 0;

    public Integer getMaxFileSize() {
        return maxFileSize;
    }

    public void setMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isMaxFileSizeSet() {
        return maxFileSizeSet;
    }

    public void setMaxFileSizeSet(boolean maxFileSizeSet) {
        this.maxFileSizeSet = maxFileSizeSet;
    }

    public String getMaxFileSizeString() {
        return maxFileSize + " (bytes)";
    }

    public String getMaxFileSizeMessage() {
        return "File size cannot exceed "+(maxFileSize/102400)*100+" KB";
    }
}
