/*
 * Copyright 2004-2014 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.icefaces.samples.showcase.example.ace.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.model.SelectItem;

import org.icefaces.samples.showcase.dataGenerators.utilityClasses.DataTableData;

import java.util.List;
import org.icefaces.ace.event.ListMoveEvent;

@ManagedBean(name= ListReorderAjaxBean.BEAN_NAME)
@CustomScoped(value = "#{window}")
public class ListReorderAjaxBean implements Serializable {
    public static final String BEAN_NAME = "listReorderAjaxBean";
	public String getBeanName() { return BEAN_NAME; }

    List<SelectItem> ajaxStringList = new ArrayList<SelectItem>() {{
        for (String s : DataTableData.CHASSIS_ALL) {
            add(new SelectItem(s));
        }
    }};

    public List<SelectItem> getAjaxStringList() {
        return ajaxStringList;
    }

    public void setAjaxStringList(List<SelectItem> ajaxStringList) {
        this.ajaxStringList = ajaxStringList;
    }

	private List<ListMoveEvent.MoveRecord> records = null;
	public List<ListMoveEvent.MoveRecord> getRecords() { return records; }

	public void moveListener(ListMoveEvent event) {
		records = event.getMoveRecords();
	}
}
