/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.icij.datashare.batch.BatchSearchRecord;
import org.icij.datashare.text.Project;
import org.icij.datashare.time.DatashareTime;
import org.icij.datashare.user.User;

public class BatchSearch
extends BatchSearchRecord {
    public final LinkedHashMap<String, Integer> queries;
    public final List<String> fileTypes;
    public final List<String> paths;
    public final int fuzziness;
    public final boolean phraseMatches;

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, false, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, int fuzziness) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, paths, fuzziness, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, int fuzziness, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, paths, fuzziness, phraseMatches, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> paths, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, paths, 0, phraseMatches, null);
    }

    public BatchSearch(String uuid, Project project, String name, String description, LinkedHashSet<String> queries, Date date, BatchSearchRecord.State state, User user) {
        this(uuid, project, name, description, BatchSearch.toLinkedHashMap(queries), date, state, user, 0, false, null, null, 0, false, null);
    }

    public BatchSearch(Project project, String name, String description, LinkedHashSet<String> queries, Date date) {
        this(UUID.randomUUID().toString(), project, name, description, BatchSearch.toLinkedHashMap(queries), date, BatchSearchRecord.State.QUEUED, User.local(), 0, false, null, null, 0, false, null);
    }

    public BatchSearch(String uuid, Project project, String name, String description, LinkedHashMap<String, Integer> queries, Date date, BatchSearchRecord.State state, User user, int nbResults, boolean published, List<String> fileTypes, List<String> paths, int fuzziness, boolean phraseMatches, String errorMessage) {
        super(uuid, project, name, description, queries.size(), date, state, user, nbResults, published, errorMessage);
        if (this.getNbQueries() == 0) {
            throw new IllegalArgumentException("queries cannot be empty");
        }
        this.queries = queries;
        this.fileTypes = Collections.unmodifiableList(Optional.ofNullable(fileTypes).orElse(new ArrayList()));
        this.paths = Collections.unmodifiableList(Optional.ofNullable(paths).orElse(new ArrayList()));
        this.fuzziness = fuzziness;
        this.phraseMatches = phraseMatches;
    }

    @JsonIgnore
    public List<String> getQueryList() {
        return new ArrayList<String>(this.queries.keySet());
    }

    private static LinkedHashMap<String, Integer> toLinkedHashMap(LinkedHashSet<String> queries) {
        return Optional.ofNullable(queries).orElseThrow(() -> new IllegalArgumentException("queries cannot be null")).stream().collect(Collectors.toMap(Function.identity(), i -> 0, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    @Override
    public String toString() {
        return "BatchSearch{" + this.uuid + " name='" + this.name + '\'' + " (" + (Object)((Object)this.state) + ")}";
    }
}

