/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.icij.datashare.text.Project;
import org.icij.datashare.user.User;

public class BatchSearchRecord {
    public final String uuid;
    public final boolean published;
    public final Project project;
    public final String name;
    public final String description;
    public final User user;
    public final State state;
    public final Date date;
    private final int nbQueries;
    public final int nbResults;
    public final String errorMessage;

    public BatchSearchRecord(Project project, String name, String description, int nbQueries, Date date) {
        this(UUID.randomUUID().toString(), project, name, description, nbQueries, date, State.QUEUED, User.local(), 0, false, null);
    }

    public BatchSearchRecord(String uuid, Project project, String name, String description, int nbQueries, Date date, State state, User user, int nbResults, boolean published, String errorMessage) {
        assert (date != null && uuid != null);
        this.uuid = uuid;
        this.published = published;
        this.project = project;
        this.name = name;
        this.description = description;
        this.user = user;
        this.date = date;
        this.nbResults = nbResults;
        this.nbQueries = nbQueries;
        this.state = state;
        this.errorMessage = errorMessage;
    }

    public Date getDate() {
        return this.date;
    }

    public int getNbQueries() {
        return this.nbQueries;
    }

    public String toString() {
        return "BatchSearchSummary{" + this.uuid + " name='" + this.name + '\'' + " (" + (Object)((Object)this.state) + ")}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchSearchRecord that = (BatchSearchRecord)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public static enum State {
        QUEUED,
        RUNNING,
        SUCCESS,
        FAILURE;

    }
}

