/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JarUtil {
    public static void createJar(Path pathToJar, String jarName, File ... javaSources) throws IOException {
        final Path jarRoot = pathToJar.resolve("jar");
        jarRoot.toFile().mkdirs();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(new DiagnosticCollector(), null, null);
        Iterable<? extends JavaFileObject> compUnits = fileManager.getJavaFileObjects(javaSources);
        compiler.getTask(null, fileManager, null, Arrays.asList("-d", jarRoot.toString()), null, compUnits).call();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        final JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(pathToJar.resolve(jarName + ".jar").toString()), manifest);
        try (final BufferedOutputStream bos = new BufferedOutputStream(target);){
            Files.walkFileTree(jarRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path classFilePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    int c;
                    BufferedInputStream br = new BufferedInputStream(new FileInputStream(classFilePath.toFile()));
                    target.putNextEntry(new JarEntry(jarRoot.relativize(classFilePath).toString()));
                    byte[] buffer = new byte[1024];
                    while ((c = br.read(buffer)) != -1) {
                        bos.write(buffer, 0, c);
                    }
                    br.close();
                    bos.flush();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void createJar(Path pathToJar, String jarName, String ... javaSources) throws IOException {
        Path srcRoot = pathToJar.resolve("src");
        srcRoot.toFile().mkdirs();
        Pattern pattern = Pattern.compile(".*package ([a-zA-Z.]*);.*class ([a-zA-Z]*).*", 32);
        LinkedList<File> files = new LinkedList<File>();
        for (String javaSource : javaSources) {
            Matcher matcher = pattern.matcher(javaSource);
            if (!matcher.matches()) continue;
            String packageName = matcher.group(1);
            String className = matcher.group(2);
            String path = packageName.replaceAll("\\.", "/");
            Path pathToSource = srcRoot.resolve(path);
            pathToSource.toFile().mkdirs();
            Path sourcePath = pathToSource.resolve(className + ".java");
            Files.write(sourcePath, Arrays.asList(javaSource.split("\n")), new OpenOption[0]);
            files.add(sourcePath.toFile());
        }
        JarUtil.createJar(pathToJar, jarName, files.toArray(new File[0]));
    }
}

