/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.nlp.Pipeline;

public class DocumentBuilder {
    private String id;
    private String content;
    private Path path;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private String mimeType;
    private Set<Pipeline.Type> pipelines;
    private String rootId = null;
    private Language language = Language.ENGLISH;

    public static DocumentBuilder createDoc(String id) {
        return new DocumentBuilder(id);
    }

    private DocumentBuilder(String id) {
        this.id = id;
        this.content = id;
        this.path = Paths.get("/path/to/", new String[0]).resolve(id);
        this.mimeType = "text/plain";
        this.pipelines = new HashSet<Pipeline.Type>();
    }

    public DocumentBuilder with(String content) {
        this.content = content;
        return this;
    }

    public DocumentBuilder with(Path path) {
        this.path = path;
        return this;
    }

    public DocumentBuilder with(Language language) {
        this.language = language;
        return this;
    }

    public DocumentBuilder with(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Document build() {
        return new Document(Project.project("prj"), this.id, this.path, this.content, this.language, Charset.defaultCharset(), this.mimeType, this.metadata, Document.Status.INDEXED, this.pipelines, new Date(), this.rootId, this.rootId, (short)0, 123L);
    }

    public DocumentBuilder ofMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public DocumentBuilder with(Pipeline.Type ... pipelineTypes) {
        this.pipelines = Arrays.stream(pipelineTypes).collect(Collectors.toSet());
        return this;
    }

    public DocumentBuilder withRootId(String rootId) {
        this.rootId = rootId;
        return this;
    }
}

