/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;

public enum Hasher {
    SHA_1(40),
    SHA_256(64),
    SHA_384(96),
    SHA_512(128);

    public static final Charset DEFAULT_ENCODING;
    private final String algorithm = this.name().replace('_', '-');
    public final int digestLength;
    static final String HEXES = "0123456789abcdef";

    private Hasher(int digestLen) {
        this.digestLength = digestLen;
    }

    public static Hasher valueOf(int length) {
        return Arrays.stream(Hasher.values()).filter(h -> h.digestLength == length).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public String toString() {
        return this.algorithm;
    }

    public String hash(String message) {
        return this.hash(message, DEFAULT_ENCODING);
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public String hash(String message, Charset charset) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            digest.update(message.getBytes(charset));
            return Hasher.getHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String hash(Path filePath) {
        try (InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);){
            String string = this.hash(stream);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot hash document", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String hash(Path filePath, String prefix) {
        try (InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);){
            String string = this.hash(stream, prefix);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot hash document", e);
        }
    }

    public String hash(InputStream stream) {
        return this.hash(stream, "");
    }

    private String hash(InputStream stream, String prefix) {
        try {
            int readCount;
            if (stream == null || stream.available() == 0) {
                return "";
            }
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            digest.update(prefix.getBytes());
            byte[] buffer = new byte[4096];
            while ((readCount = stream.read(buffer)) >= 0) {
                digest.update(buffer, 0, readCount);
            }
            byte[] hashedBytes = digest.digest();
            return Hasher.getHex(hashedBytes);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Optional<Hasher> parse(String algo) {
        if (algo == null || algo.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Hasher.valueOf(algo.toUpperCase(Locale.ROOT).replace('-', '_')));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static String shorten(String s, int l) {
        return s.substring(0, l) + "..." + s.substring(s.length() - l);
    }

    static {
        DEFAULT_ENCODING = StandardCharsets.UTF_8;
    }
}

