/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.icij.datashare.function.ThrowingFunction;

public enum NlpStage {
    SENTENCE,
    TOKEN,
    LEMMA,
    POS,
    NER;

    public static ThrowingFunction<List<String>, List<NlpStage>> parseAll;

    public static Optional<NlpStage> parse(String stage) {
        if (stage == null || stage.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(NlpStage.valueOf(stage.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    static {
        parseAll = list -> list.stream().map(NlpStage::parse).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

