/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.icij.datashare.function.ThrowingFunctions;
import org.icij.datashare.reflect.EnumTypeToken;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.nlp.NlpStage;

public interface Pipeline {
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final List<NlpStage> DEFAULT_TARGET_STAGES = Collections.singletonList(NlpStage.NER);
    public static final List<NamedEntity.Category> DEFAULT_ENTITIES = Arrays.asList(NamedEntity.Category.PERSON, NamedEntity.Category.ORGANIZATION, NamedEntity.Category.LOCATION);
    public static final boolean DEFAULT_CACHING = true;

    public static Set<Type> set(Type ... types) {
        return new HashSet<Type>(Arrays.asList(types));
    }

    public Type getType();

    public boolean initialize(Language var1) throws InterruptedException;

    public List<NamedEntity> process(Document var1) throws InterruptedException;

    public void terminate(Language var1) throws InterruptedException;

    public boolean supports(NlpStage var1, Language var2);

    public List<NamedEntity.Category> getTargetEntities();

    public List<NlpStage> getStages();

    public boolean isCaching();

    public Charset getEncoding();

    public Optional<String> getPosTagSet(Language var1);

    public static enum Property {
        STAGES,
        ENTITIES,
        CACHING,
        LANGUAGE,
        ENCODING;

        public static Function<List<NlpStage>, Function<List<NamedEntity.Category>, Function<Boolean, Properties>>> build;

        public String getName() {
            return this.name().toLowerCase().replace('_', '-');
        }

        static {
            build = nlpStages -> entityCategories -> enableCaching -> {
                Properties properties = new Properties();
                properties.setProperty(STAGES.getName(), ThrowingFunctions.joinComma.apply((List<?>)nlpStages));
                properties.setProperty(ENTITIES.getName(), ThrowingFunctions.joinComma.apply((List<?>)entityCategories));
                properties.setProperty(CACHING.getName(), String.valueOf(enableCaching));
                return properties;
            };
        }
    }

    public static enum Type implements EnumTypeToken
    {
        TEST(-1),
        CORENLP(0),
        GATENLP(1),
        IXAPIPE(2),
        MITIE(3),
        OPENNLP(4),
        EMAIL(5);

        private final String className;
        public final short code;
        public final int mask;

        private Type(short code) {
            this.code = code;
            this.mask = 1 << code;
            this.className = this.buildClassName(Pipeline.class, this);
        }

        public static Type fromCode(int code) {
            for (Type t : Type.values()) {
                if (t.code != code) continue;
                return t;
            }
            throw new IllegalArgumentException("cannot find code " + code);
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        public static Type parse(String valueName) {
            return EnumTypeToken.parse(Type.class, valueName).orElseThrow(() -> new IllegalArgumentException("unknown pipeline type: " + valueName));
        }

        public static Optional<Type> fromClassName(String className) {
            return EnumTypeToken.parseClassName(Pipeline.class, Type.class, className);
        }

        public static Set<Type> parseAll(String comaSeparatedTypes) {
            return comaSeparatedTypes == null || comaSeparatedTypes.isEmpty() ? new HashSet<Type>() : Arrays.stream(comaSeparatedTypes.split(",")).map(Type::valueOf).collect(Collectors.toSet());
        }
    }
}

