/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.icij.datashare.Entity;
import org.icij.datashare.json.JsonUtils;

public class User
implements Entity {
    public static final String LOCAL = "local";
    public static final String DATASHARE_PROJECTS_KEY = "datashare_projects";
    public final String id;
    public final String name;
    public final String email;
    public final String provider;
    public final Map<String, Object> details;

    public User(String id, String name, String email, String provider, String jsonDetails) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.provider = provider;
        this.details = Collections.unmodifiableMap(JsonUtils.deserialize(jsonDetails));
    }

    public User(String id, String name, String email, String provider, Map<String, Object> details) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.provider = provider;
        this.details = Collections.unmodifiableMap(details);
    }

    public User(String id, String name, String email, String provider) {
        this(id, name, email, provider, new HashMap<String, Object>());
    }

    public User(String id, String name, String email) {
        this(id, name, email, LOCAL);
    }

    public User(String id) {
        this(id, null, null, LOCAL);
    }

    public User(Map<String, Object> map) {
        this((String)map.get("uid"), (String)map.get("name"), (String)map.get("email"), (String)map.getOrDefault("provider", LOCAL), map);
    }

    public static User fromJson(String json, String provider) {
        if (json == null) {
            return null;
        }
        Map<String, Object> hashMap = JsonUtils.deserialize(json);
        hashMap.put("provider", provider);
        return new User(hashMap);
    }

    @JsonIgnore
    public List<String> getProjects() {
        return Optional.ofNullable(this.details.get(DATASHARE_PROJECTS_KEY)).orElse(new LinkedList());
    }

    @JsonIgnore
    public Map<String, Object> getDetails() {
        return this.details.entrySet().stream().filter(k -> k.getValue() != null).filter(k -> !((String)k.getKey()).equalsIgnoreCase("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonIgnore
    public String getJsonDetails() {
        return JsonUtils.serialize(this.getDetails());
    }

    public boolean isGranted(String index) {
        return this.getProjects().contains(index);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String queueName() {
        return "extract:queue_" + this.id;
    }

    @JsonIgnore
    public String getPath() {
        return this.equals(User.local()) || this.isNull() ? "" : this.id;
    }

    @JsonIgnore
    public boolean isNull() {
        return this.id == null;
    }

    @JsonIgnore
    public boolean isLocal() {
        return LOCAL.equals(this.id);
    }

    public static User local() {
        return User.localUser(LOCAL);
    }

    public static User localUser(final String id) {
        return new User((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("uid", id);
                this.put(User.DATASHARE_PROJECTS_KEY, Collections.singletonList(id + "-datashare"));
            }
        });
    }

    public static User nullUser() {
        return new User((String)null);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id);
    }
}

