/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.icij.datashare.Note;
import org.icij.datashare.UserEvent;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.NamedEntity;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.Tag;
import org.icij.datashare.text.nlp.Pipeline;
import org.icij.datashare.user.User;

public interface Repository {
    public NamedEntity getNamedEntity(String var1);

    public Document getDocument(String var1);

    public void create(List<NamedEntity> var1);

    public void create(Document var1);

    public AggregateList<User> getRecommendations(Project var1);

    public AggregateList<User> getRecommendations(Project var1, List<String> var2);

    public boolean addToHistory(List<Project> var1, UserEvent var2);

    public List<UserEvent> getUserEvents(User var1, UserEvent.Type var2, int var3, int var4);

    public int getTotalUserEvents(User var1, UserEvent.Type var2);

    public boolean deleteUserHistory(User var1, UserEvent.Type var2);

    public boolean deleteUserEvent(User var1, int var2);

    public List<Document> getDocumentsNotTaggedWithPipeline(Project var1, Pipeline.Type var2);

    public List<Document> getStarredDocuments(User var1);

    public List<String> getStarredDocuments(Project var1, User var2);

    public Set<String> getRecommentationsBy(Project var1, List<User> var2);

    public int star(Project var1, User var2, List<String> var3);

    public int unstar(Project var1, User var2, List<String> var3);

    public int recommend(Project var1, User var2, List<String> var3);

    public int unrecommend(Project var1, User var2, List<String> var3);

    public boolean tag(Project var1, String var2, Tag ... var3);

    public boolean untag(Project var1, String var2, Tag ... var3);

    public boolean tag(Project var1, List<String> var2, Tag ... var3);

    public boolean untag(Project var1, List<String> var2, Tag ... var3);

    public List<String> getDocuments(Project var1, Tag ... var2);

    public List<Tag> getTags(Project var1, String var2);

    public boolean deleteAll(String var1);

    public Project getProject(String var1);

    public List<Note> getNotes(Project var1, String var2);

    public boolean save(Note var1);

    public List<Note> getNotes(Project var1);

    public boolean getHealth();

    public boolean save(User var1);

    public User getUser(String var1);

    public static class Aggregate<T> {
        public final T item;
        public final int count;

        public Aggregate(T item, int count) {
            this.item = item;
            this.count = count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Aggregate)) {
                return false;
            }
            Aggregate aggregate = (Aggregate)o;
            return this.count == aggregate.count && Objects.equals(this.item, aggregate.item);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.count);
        }

        public String toString() {
            return this.item + "=" + this.count;
        }
    }

    public static class AggregateList<T> {
        public final List<Aggregate<T>> aggregates;
        public final int totalCount;

        public AggregateList(List<Aggregate<T>> aggregates, int totalCount) {
            this.aggregates = aggregates;
            this.totalCount = totalCount;
        }
    }
}

