/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import org.icij.datashare.text.PathSerializer;
import org.icij.datashare.text.Project;

public class SearchResult {
    public final String query;
    public final Project project;
    public final String documentId;
    public final String rootId;
    @JsonSerialize(using=PathSerializer.class)
    public final Path documentPath;
    public final String contentType;
    public final long contentLength;
    public final Date creationDate;
    public final int documentNumber;

    public SearchResult(String query, String documentId, String rootId, Path documentPath, Date creationDate, String contentType, long contentLength, int documentNumber) {
        this(query, null, documentId, rootId, documentPath, creationDate, contentType, contentLength, documentNumber);
    }

    @JsonCreator
    public SearchResult(@JsonProperty(value="query") String query, @JsonProperty(value="project") Project project, @JsonProperty(value="documentId") String documentId, @JsonProperty(value="rootId") String rootId, @JsonProperty(value="documentPath") Path documentPath, @JsonProperty(value="creationDate") Date creationDate, @JsonProperty(value="contentType") String contentType, @JsonProperty(value="contentLength") long contentLength, @JsonProperty(value="documentNumber") int documentNumber) {
        this.query = query;
        this.project = project;
        this.documentId = documentId;
        this.rootId = rootId;
        this.documentPath = documentPath;
        this.creationDate = creationDate;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.documentNumber = documentNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.query.equals(that.query) && this.documentId.equals(that.documentId);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.documentId);
    }

    public String toString() {
        return "SearchResult{query='" + this.query + '\'' + ", documentId='" + this.documentId + '\'' + '}';
    }
}

