/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.com;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.joda.time.format.ISODateTimeFormat;

public class Message {
    public final Date date;
    public final Type type;
    public final Map<Field, String> content = new HashMap<Field, String>();

    public Message(HashMap map) {
        HashMap clone = (HashMap)map.clone();
        this.type = Type.valueOf((String)clone.remove(Field.TYPE.name()));
        this.date = ISODateTimeFormat.dateTime().parseDateTime((String)clone.remove(Field.DATE.name())).toDate();
        this.addAll(clone);
    }

    public Message(Type type) {
        this.type = type;
        this.date = new Date();
    }

    public Message(Type type, Date date) {
        this.type = type;
        this.date = date;
    }

    public String toJson() {
        return "{" + this.content.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).reduce(String.format("\"%s\":\"%s\",\"%s\":\"%s\"", new Object[]{Field.TYPE, this.type, Field.DATE, ISODateTimeFormat.dateTime().print(this.date.getTime())}), (s1, s2) -> s1 + "," + s2) + "}";
    }

    public Message add(Field k, String v) {
        this.content.put(k, v);
        return this;
    }

    public Message addAll(HashMap result) {
        result.forEach((key, value) -> this.content.put(Field.valueOf((String)key), (String)value));
        return this;
    }

    public String toString() {
        return "Message{date=" + this.date + ", type=" + (Object)((Object)this.type) + ", content=" + this.content + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.date, message.date) && this.type == message.type && Objects.equals(this.content, message.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.type, this.content});
    }

    public static enum Type {
        SHUTDOWN,
        INIT_MONITORING,
        EXTRACT_NLP;

    }

    public static enum Field {
        TYPE,
        DATE,
        INDEX_NAME,
        DOC_ID,
        R_ID,
        VALUE;

    }
}

