/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.icij.datashare.DynamicClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Path extensionsDir;

    public ExtensionLoader(Path extensionsDir) {
        this.extensionsDir = extensionsDir;
    }

    public synchronized <T> void load(Consumer<T> registerFunc, Predicate<Class<?>> predicate) throws FileNotFoundException {
        File[] jars = this.getJars();
        this.LOGGER.info("read directory {} and found jars (executable): {}", (Object)this.extensionsDir, (Object)jars);
        DynamicClassLoader classLoader = (DynamicClassLoader)ClassLoader.getSystemClassLoader();
        for (File jar : jars) {
            try {
                this.LOGGER.info("loading jar {}", (Object)jar);
                classLoader.add(jar.toURI().toURL());
                Class<?> expectedClass = this.findClassesInJar(predicate, jar);
                if (expectedClass == null) continue;
                registerFunc.accept(expectedClass);
            }
            catch (IOException e) {
                this.LOGGER.error("Cannot load jar " + jar, (Throwable)e);
            }
        }
    }

    synchronized <T> Class<?> findClassesInJar(Predicate<Class<?>> predicate, File jarFile) throws IOException {
        URLClassLoader ucl = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, this.getClass().getClassLoader());
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (jarEntry.getName().endsWith(".class")) {
                String classname = jarEntry.getName().replaceAll("/", "\\.");
                if (!(classname = classname.substring(0, classname.length() - 6)).contains("$") && !"module-info".equals(classname)) {
                    try {
                        Class<?> myLoadedClass = Class.forName(classname, false, ucl);
                        if (predicate.test(myLoadedClass) && !myLoadedClass.isInterface() && !Modifier.isAbstract(myLoadedClass.getModifiers())) {
                            return myLoadedClass;
                        }
                    }
                    catch (ClassNotFoundException | LinkageError e) {
                        this.LOGGER.warn("cannot load class {}: {}", (Object)classname, (Object)e);
                    }
                }
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return null;
    }

    File[] getJars() throws FileNotFoundException {
        return Optional.ofNullable(this.extensionsDir.toFile().listFiles(file -> file.toString().endsWith(".jar") && file.canExecute())).orElseThrow(() -> new FileNotFoundException("invalid path for extensions: " + this.extensionsDir));
    }
}

