/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.icij.datashare.function.ThrowingFunction;

public class ThrowingFunctions {
    public static final ThrowingFunction<String, ThrowingFunction<List<?>, String>> join = sep -> list -> String.join((CharSequence)sep, list.stream().map(Object::toString).collect(Collectors.toList()));
    public static final ThrowingFunction<List<?>, String> joinComma = join.apply(",");
    public static final ThrowingFunction<List<?>, String> joinSemcol = join.apply(";");
    public static final ThrowingFunction<List<?>, String> joinColon = join.apply(":");
    public static final ThrowingFunction<List<?>, String> joinPipe = join.apply("|");
    public static final ThrowingFunction<String, ThrowingFunction<String, List<String>>> split = val -> str -> Arrays.asList(str.split((String)val));
    public static final ThrowingFunction<String, List<String>> splitComma = split.apply(",");
    public static final ThrowingFunction<String, List<String>> splitSemcol = split.apply(";");
    public static final ThrowingFunction<String, List<String>> splitColon = split.apply(":");
    public static final ThrowingFunction<String, List<String>> splitPipe = split.apply("|");
    public static final ThrowingFunction<String, ThrowingFunction<String, String>> removePattFrom = pttrn -> str -> str.replaceAll((String)pttrn, "");
    public static final ThrowingFunction<String, String> removeSpaces = removePattFrom.apply("(\\s+)");
    public static final ThrowingFunction<String, String> removeNewLines = removePattFrom.apply("((\\r?\\n)+)");
    public static final ThrowingFunction<String, String> trim = String::trim;
    public static final ThrowingFunction<String, Charset> parseCharset = Charset::forName;
    public static final ThrowingFunction<String, Boolean> parseBoolean = Boolean::parseBoolean;
    public static final ThrowingFunction<String, Integer> parseInt = Integer::parseInt;
    public static final ThrowingFunction<List<String>, List<Integer>> parseInts = ints -> ints.stream().map(parseInt).collect(Collectors.toList());
    public static final ThrowingFunction<List<String>, List<Boolean>> parseBooleans = ints -> ints.stream().map(parseBoolean).collect(Collectors.toList());
    public static final ThrowingFunction<Predicate<String>, ThrowingFunction<List<String>, List<String>>> filterElements = pred -> list -> list.stream().filter(pred).collect(Collectors.toList());

    private static Optional<String> getProperty(String key, Properties properties) {
        if (properties == null) {
            return Optional.empty();
        }
        String val = properties.getProperty(key);
        return Optional.ofNullable(val == null || val.isEmpty() ? null : val);
    }

    public static <T> Optional<T> getProperty(String key, Properties properties, Function<String, ? extends T> func) {
        return ThrowingFunctions.getProperty(key, properties).map(func);
    }

    public static <T> Optional<T> getProperty(String key, Properties properties, ThrowingFunction<String, ? extends T> func) {
        return ThrowingFunctions.getProperty(key, properties).map(val -> {
            try {
                return func.apply((String)val);
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

