/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.icij.datashare.Entity;
import org.icij.datashare.text.indexing.IndexId;
import org.icij.datashare.text.indexing.IndexParent;
import org.icij.datashare.text.indexing.IndexRoot;
import org.icij.datashare.text.indexing.IndexType;

public class JsonObjectMapper {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T extends Entity> Map<String, Object> getJson(T obj) {
        try {
            String json = MAPPER.writeValueAsString(obj);
            return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Entity> T getObject(final String id, final String projectId, final Map<String, Object> source, Class<T> type) {
        HashMap<String, Object> map = source == null ? new HashMap<String, Object>(){
            {
                this.put("id", id);
                this.put("projectId", projectId);
            }
        } : new HashMap<String, Object>(){
            {
                this.putAll(source);
                this.put("id", id);
                this.put("projectId", projectId);
            }
        };
        return JsonObjectMapper.getObject((Map<String, Object>)map, type);
    }

    private static <T extends Entity> T getObject(Map<String, Object> source, Class<T> type) {
        try {
            return (T)((Entity)MAPPER.readValue(MAPPER.writeValueAsString(source), type));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot deserialize object map " + source, e);
        }
    }

    public static String getType(Class<? extends Entity> cls) {
        return cls.getAnnotation(IndexType.class).value();
    }

    public static <T extends Entity> String getType(T obj) {
        return JsonObjectMapper.getType(obj.getClass());
    }

    public static <T extends Entity> String getId(T obj) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(IndexId.class)) continue;
            field.setAccessible(true);
            try {
                return (String)field.get(obj);
            }
            catch (IllegalAccessException e) {
                break;
            }
        }
        return null;
    }

    public static <T extends Entity> String getParent(T obj) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(IndexParent.class)) continue;
            field.setAccessible(true);
            try {
                return (String)field.get(obj);
            }
            catch (IllegalAccessException e) {
                break;
            }
        }
        return null;
    }

    public static <T extends Entity> String getRoot(T obj) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(IndexRoot.class)) continue;
            field.setAccessible(true);
            try {
                return (String)field.get(obj);
            }
            catch (IllegalAccessException e) {
                break;
            }
        }
        return null;
    }

    static {
        MAPPER.registerModule((Module)new Jdk8Module());
        MAPPER.registerModule((Module)new ParameterNamesModule());
        MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

