/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.document.TikaDocument;
import org.icij.spewer.FieldNames;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="outputMetadata", description="Output metadata along with extracted text. For the \"file\" output type, a corresponding JSON file is created for every input file. With indexes, metadata fields are set using an optional prefix. On by default."), @Option(name="tag", description="Set the given field to a corresponding value on each document output.", parameter="name-value-pair"), @Option(name="charset", description="Set the output encoding for text and document attributes. Defaults to UTF-8.", parameter="name")})
public abstract class Spewer
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 5169670165236652447L;
    protected boolean outputMetadata = true;
    private Charset outputEncoding = StandardCharsets.UTF_8;
    protected final Map<String, String> tags = new HashMap<String, String>();
    protected final FieldNames fields;

    public Spewer(FieldNames fields) {
        this.fields = fields;
    }

    public Spewer configure(Options<String> options) {
        options.get("outputMetadata").parse().asBoolean().ifPresent(this::outputMetadata);
        options.get("charset").value(Charset::forName).ifPresent(this::setOutputEncoding);
        options.get("tag").values().forEach(this::setTag);
        return this;
    }

    public abstract void write(TikaDocument var1, Reader var2) throws IOException;

    public abstract void writeMetadata(TikaDocument var1) throws IOException;

    public TikaDocument[] write(Path path) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public FieldNames getFields() {
        return this.fields;
    }

    public void setOutputEncoding(Charset outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public void outputMetadata(boolean outputMetadata) {
        this.outputMetadata = outputMetadata;
    }

    public boolean outputMetadata() {
        return this.outputMetadata;
    }

    public void setTags(Map<String, String> tags) {
        tags.forEach(this::setTag);
    }

    private void setTag(String name, String value) {
        this.tags.put(name, value);
    }

    private void setTag(String tag) {
        String[] pair = tag.split(":", 2);
        if (2 != pair.length) {
            throw new IllegalArgumentException(String.format("Invalid tag pair: \"%s\".", tag));
        }
        this.setTag(pair[0], pair[1]);
    }

    protected void copy(Reader input, OutputStream output) throws IOException {
        Spewer.copy(input, new OutputStreamWriter(output, this.outputEncoding));
    }

    public static void copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[1024];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter(4096);
        Spewer.copy(reader, writer);
        return writer.toString();
    }
}

