/*
 * Decompiled with CFR 0.152.
 */
package org.icij.task;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.icij.task.Option;
import org.icij.task.OptionParser;
import org.icij.time.HumanDuration;

public class StringOptionParser
implements OptionParser<String> {
    private final Option<String> option;

    public StringOptionParser(Option<String> option) {
        this.option = option;
    }

    @Override
    public Optional<Duration> asDuration() {
        return this.option.value(HumanDuration::parse);
    }

    @Override
    public Optional<Path> asPath() {
        return this.option.value(x$0 -> Paths.get(x$0, new String[0]));
    }

    @Override
    public Optional<URI> asURI() {
        return this.option.value(URI::create);
    }

    @Override
    public Optional<Charset> asCharset() {
        return this.option.value(value -> Charset.forName(value.toUpperCase()));
    }

    @Override
    public Optional<Integer> asInteger() {
        return this.option.value(Integer::valueOf);
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return this.option.value(value -> {
            if ((value = value.toLowerCase(Locale.ROOT)).equals("yes") || value.equals("on") || value.equals("true") || value.equals("1")) {
                return Boolean.TRUE;
            }
            if (value.equals("no") || value.equals("off") || value.equals("false") || value.equals("0")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid value.", value));
        });
    }

    @Override
    public boolean isOn() {
        return this.asBoolean().orElse(Boolean.FALSE).equals(Boolean.TRUE);
    }

    @Override
    public boolean isOff() {
        return this.asBoolean().orElse(Boolean.TRUE).equals(Boolean.FALSE);
    }

    @Override
    public <E extends Enum<E>> Optional<E> asEnum(Function<String, E> valueOf) {
        return this.option.value(valueOf);
    }
}

