/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.TaggedIOException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.TikaDocument;
import org.icij.spewer.FieldNames;
import org.icij.spewer.MetadataTransformer;
import org.icij.spewer.Spewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTSpewer
extends Spewer
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(RESTSpewer.class);
    private static final long serialVersionUID = -1551290699012748766L;
    private final CloseableHttpClient client;
    private final URI uri;

    public RESTSpewer(FieldNames fields, CloseableHttpClient client, URI uri) {
        super(fields);
        this.client = client;
        this.uri = uri;
    }

    @Override
    public void write(TikaDocument tikaDocument, Reader reader) throws IOException {
        HttpPut put = new HttpPut(this.uri.resolve(tikaDocument.getId()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair(this.fields.forId(), tikaDocument.getId()));
        params.add((NameValuePair)new BasicNameValuePair(this.fields.forPath(), tikaDocument.getPath().toString()));
        params.add((NameValuePair)new BasicNameValuePair(this.fields.forText(), RESTSpewer.toString(reader)));
        if (this.outputMetadata) {
            this.parametrizeMetadata(tikaDocument.getMetadata(), params);
        }
        put.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        this.put(put);
    }

    @Override
    public void writeMetadata(TikaDocument tikaDocument) throws IOException {
        HttpPut put = new HttpPut(this.uri.resolve(tikaDocument.getId()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.parametrizeMetadata(tikaDocument.getMetadata(), params);
        put.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        this.put(put);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private void parametrizeMetadata(Metadata metadata, List<NameValuePair> params) throws IOException {
        new MetadataTransformer(metadata, this.fields).transform((name, value) -> params.add((NameValuePair)new BasicNameValuePair(name, value)), (name, values) -> {
            for (String value : values) {
                params.add((NameValuePair)new BasicNameValuePair(name, value));
            }
        });
    }

    private void put(HttpPut put) throws IOException {
        logger.info(String.format("Writing to \"%s\".", put.getURI()));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)put);){
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code >= 300) {
                throw new TaggedIOException(new IOException(String.format("Unexpected response code: %d", code)), (Serializable)this);
            }
        }
    }
}

