/*
 * Decompiled with CFR 0.152.
 */
package org.icij.concurrent;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.icij.concurrent.SealableLatch;

public class BooleanSealableLatch
implements SealableLatch {
    private final Sync sync = new Sync();
    private volatile boolean sealed = false;

    @Override
    public void signal() {
        this.sync.releaseShared(1);
    }

    @Override
    public void await() throws InterruptedException {
        if (this.sealed) {
            throw new IllegalStateException("The latch is sealed.");
        }
        this.sync.acquireSharedInterruptibly(1);
    }

    @Override
    public void seal() {
        this.sealed = true;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -5948076050343927307L;

        private Sync() {
        }

        boolean isSignalled() {
            return this.getState() != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.isSignalled() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.setState(1);
            return true;
        }
    }
}

