/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.icij.extract.document.TikaDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbedParser
extends ParsingEmbeddedDocumentExtractor {
    private static final Logger logger = LoggerFactory.getLogger(EmbedParser.class);
    private static final Parser DELEGATING_PARSER = new DelegatingParser();
    final TikaDocument root;
    protected final ParseContext context;

    EmbedParser(TikaDocument root, ParseContext context) {
        super(context);
        this.root = root;
        this.context = context;
    }

    public void parseEmbedded(InputStream input, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        if (outputHtml) {
            this.writeStart(handler, metadata);
        }
        this.delegateParsing(input, (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler(handler)), metadata);
        if (outputHtml) {
            this.writeEnd(handler);
        }
    }

    void delegateParsing(InputStream input, ContentHandler handler, Metadata metadata) throws IOException, SAXException {
        try (TikaInputStream tis = TikaInputStream.get((InputStream)new CloseShieldInputStream(input));){
            Object container;
            if (input instanceof TikaInputStream && (container = ((TikaInputStream)input).getOpenContainer()) != null) {
                tis.setOpenContainer(container);
            }
            DELEGATING_PARSER.parse((InputStream)tis, handler, metadata, this.context);
        }
        catch (EncryptedDocumentException e) {
            logger.error("Unable to decrypt encrypted document embedded in document: \"{}\" ({}) (in \"{}\").", new Object[]{metadata.get("resourceName"), metadata.get("Content-Type"), this.root, e});
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_EMBEDDED_STREAM, ExceptionUtils.getFilteredStackTrace((Throwable)e));
        }
        catch (TikaException e) {
            logger.error("Unable to parse embedded document: \"{}\" ({}) (in \"{}\").", new Object[]{metadata.get("resourceName"), metadata.get("Content-Type"), this.root, e});
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_EMBEDDED_STREAM, ExceptionUtils.getFilteredStackTrace((Throwable)e));
        }
    }

    void writeStart(ContentHandler handler, Metadata metadata) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        String name = metadata.get("resourceName");
        attributes.addAttribute("", "class", "class", "CDATA", "package-entry");
        handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
        if (name != null && name.length() > 0) {
            handler.startElement("http://www.w3.org/1999/xhtml", "h1", "h1", new AttributesImpl());
            char[] chars = name.toCharArray();
            handler.characters(chars, 0, chars.length);
            handler.endElement("http://www.w3.org/1999/xhtml", "h1", "h1");
        }
    }

    void writeEnd(ContentHandler handler) throws SAXException {
        handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
    }
}

