/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.parser;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTML5Serializer
implements ContentHandler {
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final String[] emptyElements = new String[]{"area", "base", "basefont", "br", "col", "command", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    private static final String[] booleanAttributes = new String[]{"active", "async", "autofocus", "autosubmit", "checked", "compact", "declare", "default", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "required", "selected"};
    private final Writer writer;

    public HTML5Serializer(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            block7: for (int j = 0; j < length; ++j) {
                char c = ch[start + j];
                switch (c) {
                    case '<': {
                        this.writer.write("&lt;");
                        continue block7;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        continue block7;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        continue block7;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e).initCause(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.write(10);
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e).initCause(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (XHTML_NS.equals(namespaceURI) && Arrays.binarySearch(emptyElements, localName) < 0) {
                this.writer.write("</");
                this.writer.write(localName);
                this.writer.write(62);
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e).initCause(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.write("<!DOCTYPE html>\n");
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e).initCause(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (XHTML_NS.equals(namespaceURI)) {
                if ("meta".equals(localName) && (atts.getIndex("", "http-equiv") != -1 || atts.getIndex("", "httpequiv") != -1)) {
                    return;
                }
                this.writer.write(60);
                this.writer.write(localName);
                int length = atts.getLength();
                boolean langPrinted = false;
                for (int i = 0; i < length; ++i) {
                    String ns = atts.getURI(i);
                    String name = null;
                    if ("".equals(ns)) {
                        name = atts.getLocalName(i);
                    } else if ("http://www.w3.org/XML/1998/namespace".equals(ns) && "lang".equals(atts.getLocalName(i))) {
                        name = "lang";
                    }
                    if (name == null || langPrinted && "lang".equals(name)) continue;
                    this.writer.write(32);
                    this.writer.write(name);
                    if ("lang".equals(name)) {
                        langPrinted = true;
                    }
                    if (Arrays.binarySearch(booleanAttributes, name) >= 0) continue;
                    this.writer.write("=\"");
                    String value = atts.getValue(i);
                    block9: for (int j = 0; j < value.length(); ++j) {
                        char c = value.charAt(j);
                        switch (c) {
                            case '<': {
                                this.writer.write("&lt;");
                                continue block9;
                            }
                            case '>': {
                                this.writer.write("&gt;");
                                continue block9;
                            }
                            case '&': {
                                this.writer.write("&amp;");
                                continue block9;
                            }
                            case '\"': {
                                this.writer.write("&quot;");
                                continue block9;
                            }
                            default: {
                                this.writer.write(c);
                            }
                        }
                    }
                    this.writer.write(34);
                }
                this.writer.write(62);
                if ("head".equals(localName)) {
                    this.writer.write("<meta charset=\"UTF-8\">");
                }
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e).initCause(e);
        }
    }

    @Override
    public void endPrefixMapping(String str) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    @Override
    public void processingInstruction(String str, String str1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String str) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String str, String str1) throws SAXException {
    }
}

