/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer.http;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.icij.spewer.http.CountdownHttpRequestRetryHandler;

public class PinnedHttpClientBuilder
extends HttpClientBuilder {
    private HostnameVerifier hostnameVerifier = null;
    private SSLContext sslContext = null;

    public static PinnedHttpClientBuilder createWithDefaults() {
        PinnedHttpClientBuilder builder = new PinnedHttpClientBuilder();
        builder.setMaxConnPerRoute(32).setMaxConnTotal(128).disableRedirectHandling().setRetryHandler((HttpRequestRetryHandler)new CountdownHttpRequestRetryHandler());
        return builder;
    }

    public PinnedHttpClientBuilder setVerifyHostname(String verifyHostname) {
        if (null == verifyHostname) {
            this.hostnameVerifier = null;
            return this;
        }
        this.hostnameVerifier = verifyHostname.equals("*") ? NoopHostnameVerifier.INSTANCE : new BodgeHostnameVerifier(verifyHostname);
        return this;
    }

    public PinnedHttpClientBuilder pinCertificate(String trustStorePath) throws RuntimeException {
        return this.pinCertificate(trustStorePath, "");
    }

    public PinnedHttpClientBuilder pinCertificate(String trustStorePath, String trustStorePassword) throws RuntimeException {
        if (null != trustStorePath) {
            try {
                TrustManagerFactory trustManager = TrustManagerFactory.getInstance("X509");
                trustManager.init(PinnedHttpClientBuilder.createTrustStore(trustStorePath, trustStorePassword));
                this.sslContext = SSLContext.getInstance("TLS");
                this.sslContext.init(null, trustManager.getTrustManagers(), null);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Unable to pin certificate: " + trustStorePath + ".", e);
            }
        } else {
            this.sslContext = null;
        }
        return this;
    }

    public CloseableHttpClient build() {
        if (null != this.hostnameVerifier) {
            super.setSSLHostnameVerifier(this.hostnameVerifier);
        }
        if (null != this.sslContext) {
            super.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.sslContext, this.hostnameVerifier));
        }
        return super.build();
    }

    public static KeyStore createTrustStore(String trustStorePath, String trustStorePassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        String trustStoreExtension = FilenameUtils.getExtension((String)trustStorePath).toUpperCase(Locale.ROOT);
        String trustStoreType = trustStoreExtension.equals("P12") ? "PKCS12" : KeyStore.getDefaultType();
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(trustStorePath));){
            if (trustStoreExtension.equals("PEM") || trustStoreExtension.equals("DER")) {
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(input);
                trustStore.load(null, null);
                trustStore.setCertificateEntry(Integer.toString(1), certificate);
            } else {
                trustStore.load(input, trustStorePassword.toCharArray());
            }
        }
        return trustStore;
    }

    public static class BodgeHostnameVerifier
    implements HostnameVerifier {
        private static final HostnameVerifier defaultVerifier = new DefaultHostnameVerifier();
        private final String verifyHostname;

        public BodgeHostnameVerifier(String verifyHostname) {
            this.verifyHostname = verifyHostname;
        }

        @Override
        public final boolean verify(String host, SSLSession session) {
            return defaultVerifier.verify(this.verifyHostname, session);
        }
    }
}

