/*
 * Decompiled with CFR 0.152.
 */
package org.icij.time;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumanDuration {
    private static final Pattern pattern = Pattern.compile("^(\\d+)(d|h|m|s|ms)?$", 2);

    public static Duration parse(String duration) {
        Matcher matcher = pattern.matcher(duration);
        if (!matcher.find()) {
            throw new DateTimeParseException("Invalid time duration string.", duration, 0);
        }
        long value = Long.parseLong(matcher.group(1));
        if (null == matcher.group(2)) {
            return Duration.ofMillis(value);
        }
        switch (matcher.group(2).toLowerCase()) {
            case "d": {
                return Duration.ofDays(value);
            }
            case "h": {
                return Duration.ofHours(value);
            }
            case "m": {
                return Duration.ofMinutes(value);
            }
            case "s": {
                return Duration.ofSeconds(value);
            }
        }
        return Duration.ofMillis(value);
    }

    public static String format(Duration duration) {
        long value = duration.toMillis();
        if (value < 1000L) {
            return String.format("%sms", value);
        }
        value = duration.getSeconds();
        if (value < 60L) {
            return String.format("%ss", value);
        }
        value = duration.toMinutes();
        if (value < 60L) {
            return String.format("%sm", value);
        }
        value = duration.toHours();
        if (value < 24L) {
            return String.format("%sh", value);
        }
        value = duration.toDays();
        return String.format("%sd", value);
    }
}

