/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.queue;

import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collector;
import org.icij.extract.document.TikaDocument;

public interface DocumentQueue
extends BlockingQueue<TikaDocument>,
AutoCloseable {
    public DocumentQueue newQueue();

    default public int removeDuplicatePaths() {
        HashSet documents = new HashSet();
        int initialSize = this.size();
        this.forEach(doc -> {
            if (documents.contains(doc.getPath())) {
                this.remove(doc);
            } else {
                documents.add(doc.getPath());
            }
        });
        return initialSize - this.size();
    }

    default public Collector<TikaDocument, DocumentQueue, DocumentQueue> toDocumentQueue() {
        return Collector.of(this::newQueue, BlockingQueue::add, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, new Collector.Characteristics[0]);
    }
}

