/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.AbstractIdentifier;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;

public class DigestIdentifier
extends AbstractIdentifier {
    protected DigestIdentifier(String algorithm, Charset charset) {
        super(algorithm, charset);
    }

    @Override
    public String generate(TikaDocument tikaDocument) {
        return this.hash(tikaDocument).toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String generateForEmbed(EmbeddedTikaDocument embed) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        Metadata metadata = embed.getMetadata();
        String embeddedRelationshipId = metadata.get("embeddedRelationshipId");
        String name = metadata.get("resourceName");
        String hash = this.hash(embed);
        if (null == hash) {
            throw new IllegalStateException(String.format("No hash is available for the document with name \"%s\" at path \"%s\".", name, embed.getPath()));
        }
        digest.update(hash.getBytes(this.charset));
        digest.update(embed.getParent().getId().getBytes(this.charset));
        if (null != embeddedRelationshipId) {
            digest.update(embeddedRelationshipId.getBytes(this.charset));
        }
        if (null != name) {
            digest.update(name.getBytes(this.charset));
        }
        return DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase(Locale.ENGLISH);
    }
}

