/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CachingTesseractOCRParser
extends TesseractOCRParser {
    private static final long serialVersionUID = -5718575465763633880L;
    private static final TesseractOCRConfig DEFAULT_CONFIG = new TesseractOCRConfig();
    private final Path outputPath;

    public CachingTesseractOCRParser(Path outputPath) {
        this.outputPath = outputPath;
    }

    public void parse(InputStream in, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (null != this.outputPath) {
            this.cachedParse(in, handler, metadata, context, (TesseractOCRConfig)context.get(TesseractOCRConfig.class, (Object)DEFAULT_CONFIG), false);
        } else {
            super.parse(in, handler, metadata, context);
        }
    }

    public void parseInline(InputStream in, XHTMLContentHandler xhtml, ParseContext context, TesseractOCRConfig config) throws IOException, SAXException, TikaException {
        if (null != this.outputPath) {
            this.cachedParse(in, (ContentHandler)xhtml, new Metadata(), context, null == config ? (TesseractOCRConfig)context.get(TesseractOCRConfig.class, (Object)DEFAULT_CONFIG) : config, true);
        } else {
            super.parseInline(in, xhtml, context, config);
        }
    }

    protected void cacheHit() {
    }

    protected void cacheMiss() {
    }

    private void fallbackParse(InputStream in, ContentHandler handler, Metadata metadata, ParseContext context, TesseractOCRConfig config, boolean inline) throws SAXException, IOException, TikaException {
        if (inline) {
            XHTMLContentHandler xhtml = handler instanceof XHTMLContentHandler ? (XHTMLContentHandler)handler : new XHTMLContentHandler(handler, metadata);
            super.parseInline(in, xhtml, context, config);
        } else {
            super.parse(in, handler, metadata, context);
        }
    }

    private void parseToCache(TikaInputStream tis, ContentHandler handler, Metadata metadata, ParseContext context, TesseractOCRConfig config, boolean inline, Writer writer) throws SAXException, IOException, TikaException {
        TeeContentHandler tee = new TeeContentHandler(new ContentHandler[]{handler, new WriteOutContentHandler(writer)});
        if (inline) {
            super.parseInline((InputStream)tis, new XHTMLContentHandler((ContentHandler)tee, metadata), context, config);
        } else {
            super.parse((InputStream)tis, (ContentHandler)tee, metadata, context);
        }
    }

    private void readFromCache(Reader reader, ContentHandler handler, Metadata metadata) throws SAXException, IOException {
        XHTMLContentHandler xhtml = handler instanceof XHTMLContentHandler ? (XHTMLContentHandler)handler : new XHTMLContentHandler(handler, metadata);
        xhtml.startElement("div", "class", "ocr");
        this.readFully(reader, xhtml);
        xhtml.endElement("div");
    }

    private void readFully(Reader reader, XHTMLContentHandler xhtml) throws IOException, SAXException {
        char[] buffer = new char[1024];
        int n = reader.read(buffer);
        while (n != -1) {
            if (n > 0) {
                xhtml.characters(buffer, 0, n);
            }
            n = reader.read(buffer);
        }
    }

    private boolean acquireLock(TesseractOCRConfig config, Path cacheLock) throws IOException, InterruptedException {
        int l = config.getTimeout() + 1;
        for (int i = 0; i < l; ++i) {
            try {
                Files.createFile(cacheLock, new FileAttribute[0]);
                return true;
            }
            catch (FileAlreadyExistsException e) {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
        }
        return false;
    }

    private void cachedParse(InputStream in, ContentHandler handler, Metadata metadata, ParseContext context, TesseractOCRConfig config, boolean inline) throws IOException, SAXException, TikaException {
        try (TikaInputStream tis = TikaInputStream.get((InputStream)in);){
            this.cachedParse(tis, handler, metadata, context, config, inline);
        }
        catch (InterruptedException e) {
            throw new TikaException("Interrupted.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachedParse(TikaInputStream tis, ContentHandler handler, Metadata metadata, ParseContext context, TesseractOCRConfig config, boolean inline) throws IOException, SAXException, TikaException, InterruptedException {
        String hash;
        try (InputStream buffered = Files.newInputStream(tis.getPath(), new OpenOption[0]);){
            hash = DigestUtils.sha256Hex((InputStream)buffered);
        }
        Path cachePath = this.outputPath.resolve(hash);
        Path cacheLock = this.outputPath.resolve(hash + ".lock");
        if (!this.acquireLock(config, cacheLock)) {
            this.fallbackParse((InputStream)tis, handler, metadata, context, config, inline);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(cachePath, StandardCharsets.UTF_8);){
            this.cacheHit();
            this.readFromCache(reader, handler, metadata);
        }
        catch (NoSuchFileException e) {
            Path cacheTemp = this.outputPath.resolve(hash + ".tmp");
            try (BufferedWriter writer = Files.newBufferedWriter(cacheTemp, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                this.cacheMiss();
                this.parseToCache(tis, handler, metadata, context, config, inline, writer);
            }
            Files.move(cacheTemp, cachePath, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            Files.deleteIfExists(cacheLock);
        }
    }
}

