/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.Identifier;
import org.icij.extract.document.TikaDocument;

public abstract class AbstractIdentifier
implements Identifier {
    private final String key;
    final String algorithm;
    final Charset charset;

    public AbstractIdentifier(String algorithm, Charset charset) {
        this.key = Identifier.getKey(algorithm);
        this.algorithm = algorithm;
        this.charset = charset;
    }

    public AbstractIdentifier() {
        this("SHA256", StandardCharsets.US_ASCII);
    }

    @Override
    public String hash(TikaDocument tikaDocument) {
        return this.retrieveHash(tikaDocument.getMetadata());
    }

    @Override
    public String retrieveHash(Metadata metadata) {
        return metadata.get(this.key);
    }
}

